package com.yodo1.mas.mediation.vungle;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.vungle.ads.AdConfig;
import com.vungle.ads.BaseAd;
import com.vungle.ads.RewardedAd;
import com.vungle.ads.RewardedAdListener;
import com.vungle.ads.VungleError;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasVungleRewardAdapter extends Yodo1MasRewardAdapterBase {
    private RewardedAd rewardAd;

    private final RewardedAdListener rewardedAdListener = new RewardedAdListener() {
        @Override
        public void onAdRewarded(@NonNull BaseAd baseAd) {
            String message = "method: onAdRewarded, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
            callbackEarned();
        }

        @Override
        public void onAdLoaded(@NonNull BaseAd baseAd) {
            String message = "method: onAdLoaded, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward
                    , advertCode, baseAd.getPlacementId(), true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onAdStart(@NonNull BaseAd baseAd) {
            String message = "method: onAdStart, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdImpression(@NonNull BaseAd baseAd) {
            String message = "method: onAdImpression, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdEnd(@NonNull BaseAd baseAd) {
            String message = "method: onAdEnd, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }

        @Override
        public void onAdClicked(@NonNull BaseAd baseAd) {
            String message = "method: onAdClicked, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
            callbackClick();
        }

        @Override
        public void onAdLeftApplication(@NonNull BaseAd baseAd) {
            String message = "method: onAdLeftApplication, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdFailedToLoad(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
            String message = "method: onAdFailedToLoad, placementId: " + baseAd.getPlacementId() + ", exception: " + vungleError.getErrorMessage() + "}";
            Yodo1MasLog.d(TAG, message);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward
                    , advertCode, baseAd.getPlacementId(), false, getAdLoadDuration(), vungleError.getCode() + "", vungleError.getErrorMessage());
            callbackError(error, vungleError.getCode(), vungleError.getErrorMessage(), adRequestResult);
        }

        @Override
        public void onAdFailedToPlay(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
            String message = "method: onAdFailedToPlay, placementId: " + baseAd.getPlacementId() + ", exception: " + vungleError.getErrorMessage() + "}";
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, vungleError.getCode(), vungleError.getErrorMessage(), null);
        }
    };

    public Yodo1MasVungleRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && rewardAd.canPlayAd();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d(TAG, message);
        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();

        rewardAd = new RewardedAd(activity, adId, new AdConfig());
        rewardAd.setAdListener(rewardedAdListener);
        rewardAd.load(null);
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d(TAG, message);
            rewardAd.play(activity);
        }
    }
}
