package com.yodo1.mas.mediation.vungle;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;

import androidx.annotation.NonNull;

import com.vungle.ads.BannerAd;
import com.vungle.ads.BannerAdListener;
import com.vungle.ads.BannerAdSize;
import com.vungle.ads.BaseAd;
import com.vungle.ads.VungleError;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasVungleBannerAdapter extends Yodo1MasBannerAdapterBase {

    private BannerAd bannerAd;
    private String currBannerUnitId;
    private final BannerAdListener bannerAdListener = new BannerAdListener() {
        @Override
        public void onAdLoaded(@NonNull BaseAd baseAd) {
            String message = "method: onAdLoaded, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);

            if (getBannerAdId() != null && baseAd.getPlacementId().equals(getBannerAdId().adId)) {
                bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
                trackAdRequestSuccessed();
                callback(Yodo1MasAdEvent.CODE_LOADED, TAG + ":{" + message + "}");

                advertAdapterState = AdvertAdapterState.LOADED;
                callbackAdapterState();
            }
        }

        @Override
        public void onAdStart(@NonNull BaseAd baseAd) {
            String message = "method: onAdStart, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
            if (getBannerAdId() != null && baseAd.getPlacementId().equals(getBannerAdId().adId)) {
                callback(Yodo1MasAdEvent.CODE_OPENED, message);
            }
        }

        @Override
        public void onAdImpression(@NonNull BaseAd baseAd) {

        }

        @Override
        public void onAdEnd(@NonNull BaseAd baseAd) {
            String message = "method: onAdEnd, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
            if (getBannerAdId() != null && baseAd.getPlacementId().equals(getBannerAdId().adId)) {
                callback(Yodo1MasAdEvent.CODE_CLOSED, message);
                loadBannerAdvert();
            }
        }

        @Override
        public void onAdClicked(@NonNull BaseAd baseAd) {
            String message = "method: onAdClicked, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdLeftApplication(@NonNull BaseAd baseAd) {
            String message = "method: onAdLeftApplication, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdFailedToLoad(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
            String message = "method: onAdFailedToLoad, placementId: " + baseAd.getPlacementId() + ", exception: " + vungleError.getErrorMessage() + "}";
            Yodo1MasLog.d(TAG, message);

            if (getBannerAdId() != null && baseAd.getPlacementId().equals(getBannerAdId().adId)) {
                trackAdRequestFailed(vungleError.getCode(), vungleError.getErrorMessage());
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;

                if (isLastPlacement()) {
                    Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
                    callback(error);
                    advertAdapterState = AdvertAdapterState.FAILED;
                    callbackAdapterState();
                } else {
                    nextBanner();
                    loadBannerAdvertDelayed();
                }
            }
        }

        @Override
        public void onAdFailedToPlay(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
            String message = "method: onError, placementId: " + baseAd.getPlacementId() + ", exception: " + vungleError.getErrorMessage() + "}";
            Yodo1MasLog.d(TAG, message);

            if (getBannerAdId() != null && baseAd.getPlacementId().equals(getBannerAdId().adId)) {
                if (isLastPlacement()) {
                    Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
                    callbackDisplayError(error, vungleError.getCode(), vungleError.getErrorMessage());
                    advertAdapterState = AdvertAdapterState.FAILED;
                    callbackAdapterState();
                } else {
                    nextBanner();
                    loadBannerAdvertDelayed();
                }
            }
        }
    };

    public Yodo1MasVungleBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    @Override
    public boolean isBannerAdvertLoaded() {
        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        return bannerAd != null && !TextUtils.isEmpty(adId.adId) && bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);

        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        if (adId != null && adId.object != null && !isPriceValuable(adId)) {
            handlePricyNotAbaliable();
            return;
        }

        if (adId != null && !TextUtils.isEmpty(adId.adId) && (TextUtils.isEmpty(currBannerUnitId) || !adId.adId.equals(currBannerUnitId))) {
            BannerAdSize bannerSize = getBannerSize();
            bannerAd = new BannerAd(activity, adId.adId, bannerSize);
            bannerAd.setAdListener(bannerAdListener);
            currBannerUnitId = adId.adId;
        }

        if (bannerAd != null && bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Yodo1MasLog.d(TAG, message);

            bannerAd.load(null);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            advertAdapterState = AdvertAdapterState.LOADING;
            logAdIdInfo(adId);
        }

    }

    private BannerAdSize getBannerSize() {
        Yodo1MasBannerAdSize size = bannerConfig.size;
        Yodo1MasLog.d(TAG, "setBannerSize: size: " + size.name());

        if (Yodo1MasBannerAdSize.Banner == size) {
            return BannerAdSize.BANNER;
        }
        if (Yodo1MasBannerAdSize.IABMediumRectangle == size) {
            return BannerAdSize.VUNGLE_MREC;
        }

        return BannerAdSize.BANNER;
    }

    @Override
    public View getBannerView() {
        return bannerAd.getBannerView();
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerAd != null) {
            if (destroy) {
                bannerAd.finishAd();
                bannerAd.setAdListener(null);
                bannerAd = null;
                currBannerUnitId = null;
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                advertAdapterState = AdvertAdapterState.NONE;
            }
        }
    }

    @Override
    public boolean isSupportMultipleInstance() {
        return false;
    }

}
