/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.vungle;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.ads.InitializationListener;
import com.vungle.ads.VungleAds;
import com.vungle.ads.VungleError;
import com.vungle.ads.VunglePrivacySettings;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.vungle.Yodo1MasVungleBannerAdapter;
import com.yodo1.mas.mediation.vungle.Yodo1MasVungleInterstitialAdapter;
import com.yodo1.mas.mediation.vungle.Yodo1MasVungleRewardAdapter;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

public class Yodo1MasVungleAdapter
extends Yodo1MasAdapterBase {
    public static void setVunglePrivacy() {
        VunglePrivacySettings.setGDPRStatus((boolean)Yodo1MasHelper.getInstance().isGDPRUserConsent(), (String)"1.0.0");
        VunglePrivacySettings.setCCPAStatus((!Yodo1MasHelper.getInstance().isCCPADoNotSell() ? 1 : 0) != 0);
    }

    private void setVungleCOPPAPrivacy() {
        VunglePrivacySettings.setCOPPAStatus((boolean)Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
    }

    public String getAdvertCode() {
        return "vungle";
    }

    public String networkName() {
        return "Liftoff Monetize";
    }

    public String getSDKVersion() {
        return "7.4.3";
    }

    public String getMediationVersion() {
        return "4.15.2-beta.1";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, final @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            this.init = true;
            if (!VungleAds.isInitialized()) {
                if (!TextUtils.isEmpty((CharSequence)config.appId)) {
                    this.setVungleCOPPAPrivacy();
                    VungleAds.init((Context)activity.getApplicationContext(), (String)config.appId, (InitializationListener)new InitializationListener(){

                        public void onSuccess() {
                            String message = "method: onSuccess, init successful";
                            Yodo1MasLog.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
                            Yodo1MasVungleAdapter.this.updatePrivacy();
                            if (callback != null) {
                                callback.onAdapterInitSuccessful(Yodo1MasVungleAdapter.this.getAdvertCode());
                            }
                        }

                        public void onError(@NonNull VungleError vungleError) {
                            String message = "method: onError, exception: " + vungleError.getErrorMessage();
                            Yodo1MasLog.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
                            if (callback != null) {
                                callback.onAdapterInitFailed(Yodo1MasVungleAdapter.this.getAdvertCode(), new Yodo1MasError(-600001, message));
                            }
                        }
                    });
                } else if (callback != null) {
                    callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, "config.appId is null"));
                }
            }
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public boolean isInitSDK() {
        return super.isInitSDK() && VungleAds.isInitialized();
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        Yodo1MasVungleAdapter.setVunglePrivacy();
    }

    public Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasVungleRewardAdapter.class;
    }

    public Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasVungleInterstitialAdapter.class;
    }

    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasVungleBannerAdapter.class;
    }

    public Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}

