/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.vungle;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.vungle.ads.BannerAd;
import com.vungle.ads.BannerAdListener;
import com.vungle.ads.BannerAdSize;
import com.vungle.ads.BaseAd;
import com.vungle.ads.BaseAdListener;
import com.vungle.ads.VungleError;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import java.util.List;

public class Yodo1MasVungleBannerAdapter
extends Yodo1MasBannerAdapterBase {
    private BannerAd bannerAd;
    private String currBannerUnitId;
    private final BannerAdListener bannerAdListener = new BannerAdListener(){

        public void onAdLoaded(@NonNull BaseAd baseAd) {
            String message = "method: onAdLoaded, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleBannerAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleBannerAdapter.this.getBannerAdId() != null && baseAd.getPlacementId().equals(Yodo1MasVungleBannerAdapter.this.getBannerAdId().adId)) {
                Yodo1MasVungleBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
                Yodo1MasVungleBannerAdapter.this.trackAdRequestSuccessed();
                Yodo1MasVungleBannerAdapter.this.callback(1003, Yodo1MasVungleBannerAdapter.this.TAG + ":{" + message + "}");
                Yodo1MasVungleBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADED;
                Yodo1MasVungleBannerAdapter.this.callbackAdapterState();
            }
        }

        public void onAdStart(@NonNull BaseAd baseAd) {
            String message = "method: onAdStart, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleBannerAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleBannerAdapter.this.getBannerAdId() != null && baseAd.getPlacementId().equals(Yodo1MasVungleBannerAdapter.this.getBannerAdId().adId)) {
                Yodo1MasVungleBannerAdapter.this.callback(1001, message);
            }
        }

        public void onAdImpression(@NonNull BaseAd baseAd) {
        }

        public void onAdEnd(@NonNull BaseAd baseAd) {
            String message = "method: onAdEnd, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleBannerAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleBannerAdapter.this.getBannerAdId() != null && baseAd.getPlacementId().equals(Yodo1MasVungleBannerAdapter.this.getBannerAdId().adId)) {
                Yodo1MasVungleBannerAdapter.this.callback(1002, message);
                Yodo1MasVungleBannerAdapter.this.loadBannerAdvert();
            }
        }

        public void onAdClicked(@NonNull BaseAd baseAd) {
            String message = "method: onAdClicked, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleBannerAdapter.this.TAG, (String)message);
        }

        public void onAdLeftApplication(@NonNull BaseAd baseAd) {
            String message = "method: onAdLeftApplication, placementId: " + baseAd.getPlacementId() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleBannerAdapter.this.TAG, (String)message);
        }

        public void onAdFailedToLoad(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
            String message = "method: onAdFailedToLoad, placementId: " + baseAd.getPlacementId() + ", exception: " + vungleError.getErrorMessage() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleBannerAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleBannerAdapter.this.getBannerAdId() != null && baseAd.getPlacementId().equals(Yodo1MasVungleBannerAdapter.this.getBannerAdId().adId)) {
                Yodo1MasVungleBannerAdapter.this.trackAdRequestFailed(vungleError.getCode(), vungleError.getErrorMessage());
                Yodo1MasVungleBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                if (Yodo1MasVungleBannerAdapter.this.isLastPlacement()) {
                    Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasVungleBannerAdapter.this.TAG + ":{" + message + "}");
                    Yodo1MasVungleBannerAdapter.this.callback(error);
                    Yodo1MasVungleBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
                    Yodo1MasVungleBannerAdapter.this.callbackAdapterState();
                } else {
                    Yodo1MasVungleBannerAdapter.this.nextBanner();
                    Yodo1MasVungleBannerAdapter.this.loadBannerAdvertDelayed();
                }
            }
        }

        public void onAdFailedToPlay(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
            String message = "method: onError, placementId: " + baseAd.getPlacementId() + ", exception: " + vungleError.getErrorMessage() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleBannerAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleBannerAdapter.this.getBannerAdId() != null && baseAd.getPlacementId().equals(Yodo1MasVungleBannerAdapter.this.getBannerAdId().adId)) {
                if (Yodo1MasVungleBannerAdapter.this.isLastPlacement()) {
                    Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasVungleBannerAdapter.this.TAG + ":{" + message + "}");
                    Yodo1MasVungleBannerAdapter.this.callbackDisplayError(error, vungleError.getCode(), vungleError.getErrorMessage());
                    Yodo1MasVungleBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
                    Yodo1MasVungleBannerAdapter.this.callbackAdapterState();
                } else {
                    Yodo1MasVungleBannerAdapter.this.nextBanner();
                    Yodo1MasVungleBannerAdapter.this.loadBannerAdvertDelayed();
                }
            }
        }
    };

    public Yodo1MasVungleBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    public boolean isBannerAdvertLoaded() {
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        return this.bannerAd != null && !TextUtils.isEmpty((CharSequence)adId.adId) && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (adId != null && adId.object != null && !this.isPriceValuable(adId)) {
            this.handlePricyNotAbaliable();
            return;
        }
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || !TextUtils.isEmpty((CharSequence)this.currBannerUnitId) && adId.adId.equals(this.currBannerUnitId))) {
            BannerAdSize bannerSize = this.getBannerSize();
            this.bannerAd = new BannerAd((Context)activity, adId.adId, bannerSize);
            this.bannerAd.setAdListener((BaseAdListener)this.bannerAdListener);
            this.currBannerUnitId = adId.adId;
        }
        if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            this.bannerAd.load(null);
            this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADING;
            this.logAdIdInfo(adId);
        }
    }

    private BannerAdSize getBannerSize() {
        Yodo1MasBannerAdSize size = this.bannerConfig.size;
        Yodo1MasLog.d((String)this.TAG, (String)("setBannerSize: size: " + size.name()));
        if (Yodo1MasBannerAdSize.Banner == size) {
            return BannerAdSize.BANNER;
        }
        if (Yodo1MasBannerAdSize.IABMediumRectangle == size) {
            return BannerAdSize.VUNGLE_MREC;
        }
        return BannerAdSize.BANNER;
    }

    public View getBannerView() {
        return this.bannerAd.getBannerView();
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null && destroy) {
            this.bannerAd.finishAd();
            this.bannerAd.setAdListener(null);
            this.bannerAd = null;
            this.currBannerUnitId = null;
            this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.NONE;
        }
    }

    public boolean isSupportMultipleInstance() {
        return false;
    }
}

