/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.vungle;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.AdConfig;
import com.vungle.warren.Banners;
import com.vungle.warren.InitCallback;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.vungle.warren.VungleBanner;
import com.vungle.warren.error.VungleException;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.analytics.Yodo1MasSensorHelper;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasBanner;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import org.json.JSONObject;

public class Yodo1MasVungleAdapter
extends Yodo1MasAdapterBase {
    private VungleBanner bannerAd;
    private String currBannerUnitId;
    private final LoadAdCallback loadListener = new LoadAdCallback(){

        public void onAdLoad(String placementId) {
            String message = "method: onAdLoad, placementId: " + placementId + "}";
            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getRewardAdId().adId)) {
                Yodo1MasVungleAdapter.this.trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.SUCCESS);
            } else if (Yodo1MasVungleAdapter.this.getInterstitialAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getInterstitialAdId().adId)) {
                Yodo1MasVungleAdapter.this.trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.SUCCESS);
            } else if (Yodo1MasVungleAdapter.this.getBannerAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getBannerAdId().adId)) {
                Yodo1MasVungleAdapter.this.trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.SUCCESS);
                Yodo1MasVungleAdapter.this.callback(1003, Yodo1Mas.AdType.Banner, Yodo1MasVungleAdapter.this.TAG + ":{" + message + "}");
            }
        }

        public void onError(String placementId, VungleException exception) {
            String message = "method: onError, placementId: " + placementId + "exception: " + exception.toString() + "}";
            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasVungleAdapter.this.TAG + ":{" + message + "}");
            if (Yodo1MasVungleAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getRewardAdId().adId)) {
                Yodo1MasVungleAdapter.this.trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.FAIL);
                Yodo1MasVungleAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
                Yodo1MasVungleAdapter.this.nextReward();
                Yodo1MasVungleAdapter.this.loadRewardAdvertDelayed();
            } else if (Yodo1MasVungleAdapter.this.getInterstitialAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getInterstitialAdId().adId)) {
                Yodo1MasVungleAdapter.this.trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.FAIL);
                Yodo1MasVungleAdapter.this.callback(error, Yodo1Mas.AdType.Interstitial);
                Yodo1MasVungleAdapter.this.nextInterstitial();
                Yodo1MasVungleAdapter.this.loadInterstitialAdvertDelayed();
            } else if (Yodo1MasVungleAdapter.this.getBannerAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getBannerAdId().adId)) {
                Yodo1MasVungleAdapter.this.trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.FAIL);
                Yodo1MasVungleAdapter.this.callback(error, Yodo1Mas.AdType.Banner);
                Yodo1MasVungleAdapter.this.nextBanner();
                Yodo1MasVungleAdapter.this.loadBannerAdvertDelayed();
            }
        }
    };
    private final PlayAdCallback adsListener = new PlayAdCallback(){

        public void onAdStart(String placementId) {
            String message = "method: onAdStart, placementId: " + placementId + "}";
            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getRewardAdId().adId)) {
                Yodo1MasVungleAdapter.this.callback(1001, Yodo1Mas.AdType.Reward, Yodo1MasVungleAdapter.this.TAG + ":{" + message + "}");
            } else if (Yodo1MasVungleAdapter.this.getInterstitialAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getInterstitialAdId().adId)) {
                Yodo1MasVungleAdapter.this.callback(1001, Yodo1Mas.AdType.Interstitial, message);
            } else if (Yodo1MasVungleAdapter.this.getBannerAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getBannerAdId().adId)) {
                Yodo1MasVungleAdapter.this.callback(1001, Yodo1Mas.AdType.Banner, message);
            }
        }

        public void onAdEnd(String placementId, boolean completed, boolean isCTAClicked) {
        }

        public void onAdEnd(String placementId) {
            String message = "method: onEnd, placementId: " + placementId + "}";
            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getRewardAdId().adId)) {
                Yodo1MasVungleAdapter.this.callback(1002, Yodo1Mas.AdType.Reward, Yodo1MasVungleAdapter.this.TAG + ":{" + message + "}");
                Yodo1MasVungleAdapter.this.loadRewardAdvert();
            } else if (Yodo1MasVungleAdapter.this.getInterstitialAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getInterstitialAdId().adId)) {
                Yodo1MasVungleAdapter.this.callback(1002, Yodo1Mas.AdType.Interstitial, message);
                Yodo1MasVungleAdapter.this.loadInterstitialAdvert();
            } else if (Yodo1MasVungleAdapter.this.getBannerAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getBannerAdId().adId)) {
                Yodo1MasVungleAdapter.this.callback(1002, Yodo1Mas.AdType.Banner, message);
                Yodo1MasVungleAdapter.this.loadBannerAdvert();
            }
        }

        public void onAdClick(String placementId) {
            String message = "method: onAdClick, placementId: " + placementId + "}";
            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
        }

        public void onAdRewarded(String placementId) {
            String message = "method: onAdRewarded, placementId: " + placementId + "}";
            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getRewardAdId().adId)) {
                Yodo1MasVungleAdapter.this.callback(2001, Yodo1Mas.AdType.Reward, Yodo1MasVungleAdapter.this.TAG + ":{" + message + "}");
            }
        }

        public void onAdLeftApplication(String placementId) {
        }

        public void onError(String placementId, VungleException exception) {
            String message = "method: onError, placementId: " + placementId + "exception: " + exception.toString() + "}";
            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasVungleAdapter.this.TAG + ":{" + message + "}");
            if (Yodo1MasVungleAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getRewardAdId().adId)) {
                Yodo1MasVungleAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
                Yodo1MasVungleAdapter.this.nextReward();
                Yodo1MasVungleAdapter.this.loadRewardAdvertDelayed();
            } else if (Yodo1MasVungleAdapter.this.getInterstitialAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getInterstitialAdId().adId)) {
                Yodo1MasVungleAdapter.this.callback(error, Yodo1Mas.AdType.Interstitial);
                Yodo1MasVungleAdapter.this.nextInterstitial();
                Yodo1MasVungleAdapter.this.loadInterstitialAdvertDelayed();
            } else if (Yodo1MasVungleAdapter.this.getBannerAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getBannerAdId().adId)) {
                Yodo1MasVungleAdapter.this.callback(error, Yodo1Mas.AdType.Banner);
                Yodo1MasVungleAdapter.this.nextBanner();
                Yodo1MasVungleAdapter.this.loadBannerAdvertDelayed();
            }
        }

        public void onAdViewed(String placementId) {
        }
    };

    public String getAdvertCode() {
        return "vungle";
    }

    public String getSDKVersion() {
        return "6.9.1";
    }

    public String getMediationVersion() {
        return "4.3.1";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, final @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            this.init = true;
            if (!Vungle.isInitialized()) {
                if (!TextUtils.isEmpty((CharSequence)config.appId)) {
                    Vungle.init((String)config.appId, (Context)activity.getApplicationContext(), (InitCallback)new InitCallback(){

                        public void onSuccess() {
                            String message = "method: onSuccess, init successful";
                            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
                            Yodo1MasVungleAdapter.this.updatePrivacy();
                            Yodo1MasVungleAdapter.this.loadRewardAdvert();
                            Yodo1MasVungleAdapter.this.loadInterstitialAdvert();
                            Yodo1MasVungleAdapter.this.loadBannerAdvert();
                            if (callback != null) {
                                callback.onAdapterInitSuccessful(Yodo1MasVungleAdapter.this.getAdvertCode());
                            }
                        }

                        public void onError(VungleException exception) {
                            String message = "method: onError, exception: " + exception.toString();
                            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
                            if (callback != null) {
                                callback.onAdapterInitFailed(Yodo1MasVungleAdapter.this.getAdvertCode(), new Yodo1MasError(-600001, message));
                            }
                        }

                        public void onAutoCacheAdAvailable(String placementId) {
                            String message = "method: onAutoCacheAdAvailable, placementId: " + placementId;
                            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
                        }
                    });
                } else if (callback != null) {
                    callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, "config.appId is null"));
                }
            }
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public boolean isInitSDK() {
        return super.isInitSDK() && Vungle.isInitialized();
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        Yodo1MasVungleAdapter.setVunglePrivacy();
    }

    public static void setVunglePrivacy() {
        Vungle.Consent gdprStatus = Yodo1MasHelper.getInstance().isGDPRUserConsent() ? Vungle.Consent.OPTED_IN : Vungle.Consent.OPTED_OUT;
        Vungle.updateConsentStatus((Vungle.Consent)gdprStatus, (String)"");
        Vungle.Consent ccpaStatus = Yodo1MasHelper.getInstance().isCCPADoNotSell() ? Vungle.Consent.OPTED_OUT : Vungle.Consent.OPTED_IN;
        Vungle.updateCCPAStatus((Vungle.Consent)ccpaStatus);
    }

    public boolean isRewardAdvertLoaded() {
        super.isRewardAdvertLoaded();
        Yodo1MasAdapterBase.AdId adId = this.getRewardAdId();
        return adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && Vungle.canPlayAd((String)adId.adId);
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getRewardAdId();
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId)) {
            String message = "method: loadRewardAdvert, loading reward ad...";
            Log.d((String)this.TAG, (String)message);
            Vungle.loadAd((String)adId.adId, (LoadAdCallback)this.loadListener);
        }
    }

    public void showRewardAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showRewardAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Reward, callback)) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            Vungle.playAd((String)this.getRewardAdId().adId, null, (PlayAdCallback)this.adsListener);
        }
    }

    public boolean isInterstitialAdvertLoaded() {
        super.isInterstitialAdvertLoaded();
        Yodo1MasAdapterBase.AdId adId = this.getInterstitialAdId();
        return adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && Vungle.canPlayAd((String)adId.adId);
    }

    public void loadInterstitialAdvert(@NonNull Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getInterstitialAdId();
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId)) {
            String message = "method: loadInterstitialAdvert, loading interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            Vungle.loadAd((String)adId.adId, (LoadAdCallback)this.loadListener);
        }
    }

    public void showInterstitialAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showInterstitialAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Interstitial, callback)) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            Vungle.playAd((String)this.getInterstitialAdId().adId, null, (PlayAdCallback)this.adsListener);
        }
    }

    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        return adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && Banners.canPlayAd((String)adId.adId, (AdConfig.AdSize)AdConfig.AdSize.BANNER);
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || !TextUtils.isEmpty((CharSequence)this.currBannerUnitId) && adId.adId.equals(this.currBannerUnitId))) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Log.d((String)this.TAG, (String)message);
            Banners.loadBanner((String)this.getBannerAdId().adId, (AdConfig.AdSize)AdConfig.AdSize.BANNER, (LoadAdCallback)this.loadListener);
            this.currBannerUnitId = adId.adId;
        }
    }

    public void showBannerAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showBannerAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Banner, callback)) {
            String message = "method: showBannerAdvert, show banner ad...";
            Log.d((String)this.TAG, (String)message);
            this.bannerAd = Banners.getBanner((String)this.getBannerAdId().adId, (AdConfig.AdSize)AdConfig.AdSize.BANNER, (PlayAdCallback)this.adsListener);
            if (this.bannerAd != null) {
                Yodo1MasBanner.showBanner((Activity)activity, (View)this.bannerAd, (JSONObject)object);
            } else {
                Yodo1MasError error = new Yodo1MasError(-600201, message);
                this.callback(error, Yodo1Mas.AdType.Banner);
                this.nextBanner();
                this.loadBannerAdvertDelayed();
            }
        }
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null) {
            Yodo1MasBanner.removeBanner((View)this.bannerAd);
            if (destroy) {
                this.bannerAd.destroyAd();
                this.bannerAd = null;
                this.currBannerUnitId = null;
                this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                this.loadBannerAdvert();
            }
        }
    }
}

