package com.yodo1.mas.mediation.vungle;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;

import com.vungle.warren.AdConfig;
import com.vungle.warren.BannerAdConfig;
import com.vungle.warren.Banners;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.VungleBanner;
import com.vungle.warren.error.VungleException;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.analytics.Yodo1MasSensorHelper;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasBannerAdapterBase;

import androidx.annotation.NonNull;

public class Yodo1MasVungleBannerAdapter extends Yodo1MasBannerAdapterBase {

    private VungleBanner bannerAd;
    private String currBannerUnitId;
    private BannerAdConfig vungleAdConfig;

    @Override
    public boolean isBannerAdvertLoaded() {
        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        return adId != null && !TextUtils.isEmpty(adId.adId) && Banners.canPlayAd(adId.adId, AdConfig.AdSize.BANNER);
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);

        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        if (adId != null && !TextUtils.isEmpty(adId.adId) && (TextUtils.isEmpty(currBannerUnitId) || !adId.adId.equals(currBannerUnitId))) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Log.d(TAG, message);

            AdConfig.AdSize bannerSize = getBannerSize();
            vungleAdConfig = new BannerAdConfig();
            vungleAdConfig.setAdSize(bannerSize);
            Banners.loadBanner(getBannerAdId().adId, vungleAdConfig, loadListener);
            currBannerUnitId = adId.adId;
        }
    }

    private AdConfig.AdSize getBannerSize() {
        Yodo1MasBannerAdSize size = bannerConfig.size;
        Log.d(TAG, "setBannerSize: size: " + size.name());

        if (Yodo1MasBannerAdSize.Banner == size) {
            return AdConfig.AdSize.BANNER;
        }

        return AdConfig.AdSize.BANNER;
    }


    @Override
    public View getBannerView() {
        bannerAd = Banners.getBanner(getBannerAdId().adId, vungleAdConfig, adsListener);
        return bannerAd;
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerAd != null) {
            if (destroy) {
                bannerAd.destroyAd();
                bannerAd = null;
                currBannerUnitId = null;
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            }
        }
    }

    @Override
    public boolean isSupportMultipleInstance() {
        return false;
    }

    private final LoadAdCallback loadListener = new LoadAdCallback() {
        @Override
        public void onAdLoad(String placementId) {
            String message = "method: onAdLoad, placementId: " + placementId + "}";
            Log.d(TAG, message);

            if (getBannerAdId() != null && placementId.equals(getBannerAdId().adId)) {
                trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.SUCCESS);
                callback(Yodo1MasAdEvent.CODE_LOADED, Yodo1Mas.AdType.Banner, TAG + ":{" + message + "}");
            }
        }

        @Override
        public void onError(String placementId, VungleException exception) {
            String message = "method: onError, placementId: " + placementId + "exception: " + exception.toString() + "}";
            Log.d(TAG, message);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            if (getBannerAdId() != null && placementId.equals(getBannerAdId().adId)) {
                trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.FAIL);
                callback(error, Yodo1Mas.AdType.Banner);

                nextBanner();
                loadBannerAdvertDelayed();
            }
        }
    };

    private final PlayAdCallback adsListener = new PlayAdCallback() {
        @Override
        public void creativeId(String creativeId) {
            String message = "method: creativeId, creativeId: " + creativeId + "}";
            Log.d(TAG, message);
        }

        @Override
        public void onAdStart(String placementId) {
            String message = "method: onAdStart, placementId: " + placementId + "}";
            Log.d(TAG, message);
            if (getBannerAdId() != null && placementId.equals(getBannerAdId().adId)) {
                callback(Yodo1MasAdEvent.CODE_OPENED, Yodo1Mas.AdType.Banner, message);
            }
        }

        @Override
        public void onAdEnd(String placementId, boolean completed, boolean isCTAClicked) {

        }

        @Override
        public void onAdEnd(String placementId) {
            String message = "method: onEnd, placementId: " + placementId + "}";
            Log.d(TAG, message);
            if (getBannerAdId() != null && placementId.equals(getBannerAdId().adId)) {
                callback(Yodo1MasAdEvent.CODE_CLOSED, Yodo1Mas.AdType.Banner, message);
                loadBannerAdvert();
            }
        }

        @Override
        public void onAdClick(String placementId) {
            String message = "method: onAdClick, placementId: " + placementId + "}";
            Log.d(TAG, message);
        }

        @Override
        public void onAdRewarded(String placementId) {
            String message = "method: onAdRewarded, placementId: " + placementId + "}";
            Log.d(TAG, message);
        }

        @Override
        public void onAdLeftApplication(String placementId) {

        }

        @Override
        public void onError(String placementId, VungleException exception) {
            String message = "method: onError, placementId: " + placementId + "exception: " + exception.toString() + "}";
            Log.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            if (getBannerAdId() != null && placementId.equals(getBannerAdId().adId)) {
                callback(error, Yodo1Mas.AdType.Banner);

                nextBanner();
                loadBannerAdvertDelayed();
            }
        }

        @Override
        public void onAdViewed(String placementId) {

        }
    };

}
