/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.vungle;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.InitCallback;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.vungle.warren.error.VungleException;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.mediation.vungle.Yodo1MasVungleBannerAdapter;
import org.json.JSONObject;

public class Yodo1MasVungleAdapter
extends Yodo1MasAdapterBase {
    private final LoadAdCallback loadListener = new LoadAdCallback(){

        public void onAdLoad(String placementId) {
            String message = "method: onAdLoad, placementId: " + placementId + "}";
            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getRewardAdId().adId)) {
                Yodo1MasVungleAdapter.this.trackAdRequestSuccessed(Yodo1Mas.AdType.Reward);
            } else if (Yodo1MasVungleAdapter.this.getInterstitialAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getInterstitialAdId().adId)) {
                Yodo1MasVungleAdapter.this.trackAdRequestSuccessed(Yodo1Mas.AdType.Interstitial);
            }
        }

        public void onError(String placementId, VungleException exception) {
            String message = "method: onError, placementId: " + placementId + "exception: " + exception.toString() + "}";
            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasVungleAdapter.this.TAG + ":{" + message + "}");
            if (Yodo1MasVungleAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getRewardAdId().adId)) {
                Yodo1MasVungleAdapter.this.trackAdRequestFailed(Yodo1Mas.AdType.Reward, exception.getExceptionCode(), exception.getLocalizedMessage());
                Yodo1MasVungleAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
                Yodo1MasVungleAdapter.this.nextReward();
                Yodo1MasVungleAdapter.this.loadRewardAdvertDelayed();
            } else if (Yodo1MasVungleAdapter.this.getInterstitialAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getInterstitialAdId().adId)) {
                Yodo1MasVungleAdapter.this.trackAdRequestFailed(Yodo1Mas.AdType.Interstitial, exception.getExceptionCode(), exception.getLocalizedMessage());
                Yodo1MasVungleAdapter.this.callback(error, Yodo1Mas.AdType.Interstitial);
                Yodo1MasVungleAdapter.this.nextInterstitial();
                Yodo1MasVungleAdapter.this.loadInterstitialAdvertDelayed();
            }
        }
    };
    private final PlayAdCallback adsListener = new PlayAdCallback(){

        public void creativeId(String creativeId) {
            String message = "method: creativeId, creativeId: " + creativeId + "}";
            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
        }

        public void onAdStart(String placementId) {
            String message = "method: onAdStart, placementId: " + placementId + "}";
            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getRewardAdId().adId)) {
                Yodo1MasVungleAdapter.this.callback(1001, Yodo1Mas.AdType.Reward, Yodo1MasVungleAdapter.this.TAG + ":{" + message + "}");
            } else if (Yodo1MasVungleAdapter.this.getInterstitialAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getInterstitialAdId().adId)) {
                Yodo1MasVungleAdapter.this.callback(1001, Yodo1Mas.AdType.Interstitial, message);
            }
        }

        public void onAdEnd(String placementId, boolean completed, boolean isCTAClicked) {
        }

        public void onAdEnd(String placementId) {
            String message = "method: onEnd, placementId: " + placementId + "}";
            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getRewardAdId().adId)) {
                Yodo1MasVungleAdapter.this.callback(1002, Yodo1Mas.AdType.Reward, Yodo1MasVungleAdapter.this.TAG + ":{" + message + "}");
                Yodo1MasVungleAdapter.this.loadRewardAdvert();
            } else if (Yodo1MasVungleAdapter.this.getInterstitialAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getInterstitialAdId().adId)) {
                Yodo1MasVungleAdapter.this.callback(1002, Yodo1Mas.AdType.Interstitial, message);
                Yodo1MasVungleAdapter.this.loadInterstitialAdvert();
            }
        }

        public void onAdClick(String placementId) {
            String message = "method: onAdClick, placementId: " + placementId + "}";
            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
        }

        public void onAdRewarded(String placementId) {
            String message = "method: onAdRewarded, placementId: " + placementId + "}";
            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getRewardAdId().adId)) {
                Yodo1MasVungleAdapter.this.callback(2001, Yodo1Mas.AdType.Reward, Yodo1MasVungleAdapter.this.TAG + ":{" + message + "}");
            }
        }

        public void onAdLeftApplication(String placementId) {
        }

        public void onError(String placementId, VungleException exception) {
            String message = "method: onError, placementId: " + placementId + "exception: " + exception.toString() + "}";
            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasVungleAdapter.this.TAG + ":{" + message + "}");
            if (Yodo1MasVungleAdapter.this.getRewardAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getRewardAdId().adId)) {
                Yodo1MasVungleAdapter.this.callbackDisplayError(error, Yodo1Mas.AdType.Reward, exception.getExceptionCode(), exception.getLocalizedMessage());
                Yodo1MasVungleAdapter.this.nextReward();
                Yodo1MasVungleAdapter.this.loadRewardAdvertDelayed();
            } else if (Yodo1MasVungleAdapter.this.getInterstitialAdId() != null && placementId.equals(((Yodo1MasVungleAdapter)Yodo1MasVungleAdapter.this).getInterstitialAdId().adId)) {
                Yodo1MasVungleAdapter.this.callbackDisplayError(error, Yodo1Mas.AdType.Interstitial, exception.getExceptionCode(), exception.getLocalizedMessage());
                Yodo1MasVungleAdapter.this.nextInterstitial();
                Yodo1MasVungleAdapter.this.loadInterstitialAdvertDelayed();
            }
        }

        public void onAdViewed(String placementId) {
        }
    };

    public String getAdvertCode() {
        return "vungle";
    }

    public String getSDKVersion() {
        return "6.10.5";
    }

    public String getMediationVersion() {
        return "4.6.2";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, final @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            this.init = true;
            if (!Vungle.isInitialized()) {
                if (!TextUtils.isEmpty((CharSequence)config.appId)) {
                    this.setVungleCOPPAPrivacy();
                    Vungle.init((String)config.appId, (Context)activity.getApplicationContext(), (InitCallback)new InitCallback(){

                        public void onSuccess() {
                            String message = "method: onSuccess, init successful";
                            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
                            Yodo1MasVungleAdapter.this.updatePrivacy();
                            Yodo1MasVungleAdapter.this.loadRewardAdvert();
                            Yodo1MasVungleAdapter.this.loadInterstitialAdvert();
                            if (callback != null) {
                                callback.onAdapterInitSuccessful(Yodo1MasVungleAdapter.this.getAdvertCode());
                            }
                        }

                        public void onError(VungleException exception) {
                            String message = "method: onError, exception: " + exception.toString();
                            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
                            if (callback != null) {
                                callback.onAdapterInitFailed(Yodo1MasVungleAdapter.this.getAdvertCode(), new Yodo1MasError(-600001, message));
                            }
                        }

                        public void onAutoCacheAdAvailable(String placementId) {
                            String message = "method: onAutoCacheAdAvailable, placementId: " + placementId;
                            Log.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
                        }
                    });
                } else if (callback != null) {
                    callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, "config.appId is null"));
                }
            }
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public boolean isInitSDK() {
        return super.isInitSDK() && Vungle.isInitialized();
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        Yodo1MasVungleAdapter.setVunglePrivacy();
    }

    private void setVungleCOPPAPrivacy() {
        Vungle.updateUserCoppaStatus((boolean)Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
    }

    public static void setVunglePrivacy() {
        Vungle.Consent gdprStatus = Yodo1MasHelper.getInstance().isGDPRUserConsent() ? Vungle.Consent.OPTED_IN : Vungle.Consent.OPTED_OUT;
        Vungle.updateConsentStatus((Vungle.Consent)gdprStatus, (String)"");
        Vungle.Consent ccpaStatus = Yodo1MasHelper.getInstance().isCCPADoNotSell() ? Vungle.Consent.OPTED_OUT : Vungle.Consent.OPTED_IN;
        Vungle.updateCCPAStatus((Vungle.Consent)ccpaStatus);
    }

    public boolean isRewardAdvertLoaded() {
        super.isRewardAdvertLoaded();
        Yodo1MasAdapterBase.AdId adId = this.getRewardAdId();
        return adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && Vungle.canPlayAd((String)adId.adId);
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getRewardAdId();
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId)) {
            String message = "method: loadRewardAdvert, loading reward ad...";
            Log.d((String)this.TAG, (String)message);
            Vungle.loadAd((String)adId.adId, (LoadAdCallback)this.loadListener);
        }
    }

    public void showRewardAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showRewardAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Reward, callback)) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            Vungle.playAd((String)this.getRewardAdId().adId, null, (PlayAdCallback)this.adsListener);
        }
    }

    public boolean isInterstitialAdvertLoaded() {
        super.isInterstitialAdvertLoaded();
        Yodo1MasAdapterBase.AdId adId = this.getInterstitialAdId();
        return adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && Vungle.canPlayAd((String)adId.adId);
    }

    public void loadInterstitialAdvert(@NonNull Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getInterstitialAdId();
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId)) {
            String message = "method: loadInterstitialAdvert, loading interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            Vungle.loadAd((String)adId.adId, (LoadAdCallback)this.loadListener);
        }
    }

    public void showInterstitialAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showInterstitialAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Interstitial, callback)) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            Vungle.playAd((String)this.getInterstitialAdId().adId, null, (PlayAdCallback)this.adsListener);
        }
    }

    public Yodo1MasBannerAdapterBase getYodo1MasBannerAdapter() {
        Yodo1MasVungleBannerAdapter bannerAdapter = new Yodo1MasVungleBannerAdapter();
        bannerAdapter.bannerAdIds.clear();
        bannerAdapter.bannerAdIds.addAll(this.bannerAdIds);
        bannerAdapter.relateAdapter = this;
        bannerAdapter.advertCode = this.getAdvertCode();
        bannerAdapter.sdkVersion = this.getSDKVersion();
        bannerAdapter.mediationVersion = this.getMediationVersion();
        return bannerAdapter;
    }
}

