package com.yodo1.mas.mediation.vungle;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;

import com.vungle.warren.Vungle;
import com.vungle.warren.error.VungleException;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class Yodo1MasVungleAdapter extends Yodo1MasAdapterBase {

    @Override
    public String getAdvertCode() {
        return "vungle";
    }

    @Override
    public String getSDKVersion() {
        return BuildConfig.SDK_VERSION_NAME;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!isInitSDK()) {
            init = true;
            if (!Vungle.isInitialized()) {
                if (!TextUtils.isEmpty(config.appId)) {
                    setVungleCOPPAPrivacy();
                    Vungle.init(config.appId, activity.getApplicationContext(), new com.vungle.warren.InitCallback() {
                        @Override
                        public void onSuccess() {
                            String message = "method: onSuccess, init successful";
                            Log.d(TAG, message);
                            updatePrivacy();
                            if (callback != null) {
                                callback.onAdapterInitSuccessful(getAdvertCode());
                            }
                        }

                        @Override
                        public void onError(VungleException exception) {
                            String message = "method: onError, exception: " + exception.toString();
                            Log.d(TAG, message);
                            if (callback != null) {
                                callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, message));
                            }
                        }

                        @Override
                        public void onAutoCacheAdAvailable(String placementId) {
                            String message = "method: onAutoCacheAdAvailable, placementId: " + placementId;
                            Log.d(TAG, message);
                        }
                    });
                } else {
                    if (callback != null) {
                        callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, "config.appId is null"));
                    }
                }
            }
        } else {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
        }
    }

    @Override
    public boolean isInitSDK() {
        return super.isInitSDK() && Vungle.isInitialized();
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        setVunglePrivacy();
    }

    /**
     * need call before initialization the Vungle SDK
     */
    private void setVungleCOPPAPrivacy() {
        Vungle.updateUserCoppaStatus(Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
    }

    public static void setVunglePrivacy() {
        Vungle.Consent gdprStatus = Yodo1MasHelper.getInstance().isGDPRUserConsent() ? Vungle.Consent.OPTED_IN : Vungle.Consent.OPTED_OUT;
        Vungle.updateConsentStatus(gdprStatus, "");

        Vungle.Consent ccpaStatus = Yodo1MasHelper.getInstance().isCCPADoNotSell() ? Vungle.Consent.OPTED_OUT : Vungle.Consent.OPTED_IN;
        Vungle.updateCCPAStatus(ccpaStatus);
    }

    // Reward
    @Override
    protected Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasVungleRewardAdapter.class;
    }

    // Interstitial
    @Override
    protected Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasVungleInterstitialAdapter.class;
    }

    // Native
    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    // Banner
    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasVungleBannerAdapter.class;
    }
}
