package com.yodo1.mas.mediation.vungle;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.vungle.warren.error.VungleException;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

import java.util.List;

public class Yodo1MasVungleRewardAdapter extends Yodo1MasRewardAdapterBase {

    private final LoadAdCallback loadListener = new LoadAdCallback() {
        @Override
        public void onAdLoad(String placementId) {
            String message = "method: onAdLoad, placementId: " + placementId + "}";
            Yodo1MasLog.d(TAG, message);
            callbackLoad();
        }

        @Override
        public void onError(String placementId, VungleException exception) {
            String message = "method: onError, placementId: " + placementId + "exception: " + exception.toString() + "}";
            Yodo1MasLog.d(TAG, message);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, exception.getExceptionCode(), exception.getLocalizedMessage());
        }
    };
    private final PlayAdCallback adsListener = new PlayAdCallback() {
        @Override
        public void creativeId(String creativeId) {
            String message = "method: creativeId, creativeId: " + creativeId + "}";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdStart(String placementId) {
            String message = "method: onAdStart, placementId: " + placementId + "}";
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdEnd(String placementId, boolean completed, boolean isCTAClicked) {

        }

        @Override
        public void onAdEnd(String placementId) {
            String message = "method: onEnd, placementId: " + placementId + "}";
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }

        @Override
        public void onAdClick(String placementId) {
            String message = "method: onAdClick, placementId: " + placementId + "}";
            Yodo1MasLog.d(TAG, message);
            callbackClick();
        }

        @Override
        public void onAdRewarded(String placementId) {
            String message = "method: onAdRewarded, placementId: " + placementId + "}";
            Yodo1MasLog.d(TAG, message);
            callbackEarned();
        }

        @Override
        public void onAdLeftApplication(String placementId) {

        }

        @Override
        public void onError(String placementId, VungleException exception) {
            String message = "method: onError, placementId: " + placementId + "exception: " + exception.toString() + "}";
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, exception.getExceptionCode(), exception.getLocalizedMessage());
        }

        @Override
        public void onAdViewed(String placementId) {

        }
    };

    public Yodo1MasVungleRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isRewardAdLoaded() {
        String adId = getAdUnitId(false);
        return !TextUtils.isEmpty(adId) && Vungle.canPlayAd(adId);
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = getAdUnitId(false);
        if (TextUtils.isEmpty(adId)) return;

        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d(TAG, message);
        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        Vungle.loadAd(adId, loadListener);
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d(TAG, message);
            String adId = getAdUnitId(false);
            Vungle.playAd(adId, null, adsListener);
        }
    }
}
