/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.vungle;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.vungle.warren.AdConfig;
import com.vungle.warren.BannerAdConfig;
import com.vungle.warren.Banners;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.VungleBanner;
import com.vungle.warren.error.VungleException;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import java.util.List;

public class Yodo1MasVungleBannerAdapter
extends Yodo1MasBannerAdapterBase {
    private final LoadAdCallback loadListener = new LoadAdCallback(){

        public void onAdLoad(String placementId) {
            String message = "method: onAdLoad, placementId: " + placementId + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleBannerAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleBannerAdapter.this.getBannerAdId() != null && placementId.equals(Yodo1MasVungleBannerAdapter.this.getBannerAdId().adId)) {
                Yodo1MasVungleBannerAdapter.this.trackAdRequestSuccessed();
                Yodo1MasVungleBannerAdapter.this.callback(1003, Yodo1MasVungleBannerAdapter.this.TAG + ":{" + message + "}");
                Yodo1MasVungleBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADED;
                Yodo1MasVungleBannerAdapter.this.callbackAdapterState();
            }
        }

        public void onError(String placementId, VungleException exception) {
            String message = "method: onError, placementId: " + placementId + "exception: " + exception.toString() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleBannerAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleBannerAdapter.this.getBannerAdId() != null && placementId.equals(Yodo1MasVungleBannerAdapter.this.getBannerAdId().adId)) {
                Yodo1MasVungleBannerAdapter.this.trackAdRequestFailed(exception.getExceptionCode(), exception.getLocalizedMessage());
                if (Yodo1MasVungleBannerAdapter.this.isLastPlacement()) {
                    Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasVungleBannerAdapter.this.TAG + ":{" + message + "}");
                    Yodo1MasVungleBannerAdapter.this.callback(error);
                    Yodo1MasVungleBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
                    Yodo1MasVungleBannerAdapter.this.callbackAdapterState();
                } else {
                    Yodo1MasVungleBannerAdapter.this.nextBanner();
                    Yodo1MasVungleBannerAdapter.this.loadBannerAdvertDelayed();
                }
            }
        }
    };
    private final PlayAdCallback adsListener = new PlayAdCallback(){

        public void creativeId(String creativeId) {
            String message = "method: creativeId, creativeId: " + creativeId + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleBannerAdapter.this.TAG, (String)message);
        }

        public void onAdStart(String placementId) {
            String message = "method: onAdStart, placementId: " + placementId + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleBannerAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleBannerAdapter.this.getBannerAdId() != null && placementId.equals(Yodo1MasVungleBannerAdapter.this.getBannerAdId().adId)) {
                Yodo1MasVungleBannerAdapter.this.callback(1001, message);
            }
        }

        public void onAdEnd(String placementId, boolean completed, boolean isCTAClicked) {
        }

        public void onAdEnd(String placementId) {
            String message = "method: onEnd, placementId: " + placementId + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleBannerAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleBannerAdapter.this.getBannerAdId() != null && placementId.equals(Yodo1MasVungleBannerAdapter.this.getBannerAdId().adId)) {
                Yodo1MasVungleBannerAdapter.this.callback(1002, message);
                Yodo1MasVungleBannerAdapter.this.loadBannerAdvert();
            }
        }

        public void onAdClick(String placementId) {
            String message = "method: onAdClick, placementId: " + placementId + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleBannerAdapter.this.TAG, (String)message);
        }

        public void onAdRewarded(String placementId) {
            String message = "method: onAdRewarded, placementId: " + placementId + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleBannerAdapter.this.TAG, (String)message);
        }

        public void onAdLeftApplication(String placementId) {
        }

        public void onError(String placementId, VungleException exception) {
            String message = "method: onError, placementId: " + placementId + "exception: " + exception.toString() + "}";
            Yodo1MasLog.d((String)Yodo1MasVungleBannerAdapter.this.TAG, (String)message);
            if (Yodo1MasVungleBannerAdapter.this.getBannerAdId() != null && placementId.equals(Yodo1MasVungleBannerAdapter.this.getBannerAdId().adId)) {
                if (Yodo1MasVungleBannerAdapter.this.isLastPlacement()) {
                    Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasVungleBannerAdapter.this.TAG + ":{" + message + "}");
                    Yodo1MasVungleBannerAdapter.this.callbackDisplayError(error, exception.getExceptionCode(), exception.getLocalizedMessage());
                    Yodo1MasVungleBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
                    Yodo1MasVungleBannerAdapter.this.callbackAdapterState();
                } else {
                    Yodo1MasVungleBannerAdapter.this.nextBanner();
                    Yodo1MasVungleBannerAdapter.this.loadBannerAdvertDelayed();
                }
            }
        }

        public void onAdViewed(String placementId) {
        }
    };
    private VungleBanner bannerAd;
    private String currBannerUnitId;
    private BannerAdConfig vungleAdConfig;

    public Yodo1MasVungleBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    public boolean isBannerAdvertLoaded() {
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        return adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && Banners.canPlayAd((String)adId.adId, (AdConfig.AdSize)AdConfig.AdSize.BANNER);
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (adId != null && adId.object != null && !this.isPriceValuable(adId)) {
            this.handlePricyNotAbaliable();
            return;
        }
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || !TextUtils.isEmpty((CharSequence)this.currBannerUnitId) && adId.adId.equals(this.currBannerUnitId))) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            AdConfig.AdSize bannerSize = this.getBannerSize();
            this.vungleAdConfig = new BannerAdConfig();
            this.vungleAdConfig.setAdSize(bannerSize);
            Banners.loadBanner((String)this.getBannerAdId().adId, (BannerAdConfig)this.vungleAdConfig, (LoadAdCallback)this.loadListener);
            this.currBannerUnitId = adId.adId;
            this.logAdIdInfo(adId);
        }
    }

    private AdConfig.AdSize getBannerSize() {
        Yodo1MasBannerAdSize size = this.bannerConfig.size;
        Yodo1MasLog.d((String)this.TAG, (String)("setBannerSize: size: " + size.name()));
        if (Yodo1MasBannerAdSize.Banner == size) {
            return AdConfig.AdSize.BANNER;
        }
        return AdConfig.AdSize.BANNER;
    }

    public View getBannerView() {
        this.bannerAd = Banners.getBanner((String)this.getBannerAdId().adId, (BannerAdConfig)this.vungleAdConfig, (PlayAdCallback)this.adsListener);
        return this.bannerAd;
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null && destroy) {
            this.bannerAd.destroyAd();
            this.bannerAd = null;
            this.currBannerUnitId = null;
            this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.NONE;
        }
    }

    public boolean isSupportMultipleInstance() {
        return false;
    }
}

