/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.vungle;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.InitCallback;
import com.vungle.warren.Vungle;
import com.vungle.warren.error.VungleException;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.vungle.Yodo1MasVungleBannerAdapter;
import com.yodo1.mas.mediation.vungle.Yodo1MasVungleInterstitialAdapter;
import com.yodo1.mas.mediation.vungle.Yodo1MasVungleRewardAdapter;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

public class Yodo1MasVungleAdapter
extends Yodo1MasAdapterBase {
    public static void setVunglePrivacy() {
        Vungle.Consent gdprStatus = Yodo1MasHelper.getInstance().isGDPRUserConsent() ? Vungle.Consent.OPTED_IN : Vungle.Consent.OPTED_OUT;
        Vungle.updateConsentStatus((Vungle.Consent)gdprStatus, (String)"");
        Vungle.Consent ccpaStatus = Yodo1MasHelper.getInstance().isCCPADoNotSell() ? Vungle.Consent.OPTED_OUT : Vungle.Consent.OPTED_IN;
        Vungle.updateCCPAStatus((Vungle.Consent)ccpaStatus);
    }

    public String getAdvertCode() {
        return "vungle";
    }

    public String getSDKVersion() {
        return "6.12.1";
    }

    public String getMediationVersion() {
        return "4.9.3";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, final @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            this.init = true;
            if (!Vungle.isInitialized()) {
                if (!TextUtils.isEmpty((CharSequence)config.appId)) {
                    this.setVungleCOPPAPrivacy();
                    Vungle.init((String)config.appId, (Context)activity.getApplicationContext(), (InitCallback)new InitCallback(){

                        public void onSuccess() {
                            String message = "method: onSuccess, init successful";
                            Yodo1MasLog.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
                            Yodo1MasVungleAdapter.this.updatePrivacy();
                            if (callback != null) {
                                callback.onAdapterInitSuccessful(Yodo1MasVungleAdapter.this.getAdvertCode());
                            }
                        }

                        public void onError(VungleException exception) {
                            String message = "method: onError, exception: " + exception.toString();
                            Yodo1MasLog.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
                            if (callback != null) {
                                callback.onAdapterInitFailed(Yodo1MasVungleAdapter.this.getAdvertCode(), new Yodo1MasError(-600001, message));
                            }
                        }

                        public void onAutoCacheAdAvailable(String placementId) {
                            String message = "method: onAutoCacheAdAvailable, placementId: " + placementId;
                            Yodo1MasLog.d((String)Yodo1MasVungleAdapter.this.TAG, (String)message);
                        }
                    });
                } else if (callback != null) {
                    callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, "config.appId is null"));
                }
            }
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public boolean isInitSDK() {
        return super.isInitSDK() && Vungle.isInitialized();
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        Yodo1MasVungleAdapter.setVunglePrivacy();
    }

    private void setVungleCOPPAPrivacy() {
        Vungle.updateUserCoppaStatus((boolean)Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
    }

    protected Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasVungleRewardAdapter.class;
    }

    protected Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasVungleInterstitialAdapter.class;
    }

    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasVungleBannerAdapter.class;
    }

    protected Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    protected Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}

