/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core.proxy;

import cn.hutool.core.exceptions.InvocationTargetRuntimeException;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.annotation.LiteflowMethod;
import com.yomahub.liteflow.annotation.LiteflowRetry;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.core.proxy.DeclWarpBean;
import com.yomahub.liteflow.core.proxy.MethodWrapBean;
import com.yomahub.liteflow.exception.ComponentMethodDefineErrorException;
import com.yomahub.liteflow.exception.LiteFlowException;
import com.yomahub.liteflow.exception.ProxyException;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.util.SerialsUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class DeclComponentProxy {
    private final LFLog LOG = LFLoggerManager.getLogger(this.getClass());
    private final DeclWarpBean declWarpBean;

    public DeclComponentProxy(DeclWarpBean declWarpBean) {
        this.declWarpBean = declWarpBean;
    }

    public NodeComponent getProxy() throws Exception {
        boolean legal;
        Object[] beanClassAnnotation = this.declWarpBean.getRawClazz().getAnnotations();
        List classes = this.declWarpBean.getMethodWrapBeanList().stream().map(methodWrapBean -> methodWrapBean.getLiteflowMethod().nodeType().getMappingClazz()).distinct().collect(Collectors.toList());
        boolean bl = legal = classes.size() == 1;
        if (!legal) {
            throw new LiteFlowException("The cmpClass of the same nodeId must be the same,you declared nodeId:" + this.declWarpBean.getNodeId() + ",cmpClass:" + this.declWarpBean.getRawClazz());
        }
        LiteflowRetry liteflowRetry = this.declWarpBean.getMethodWrapBeanList().stream().filter(methodWrapBean -> {
            LiteflowRetry lfr = methodWrapBean.getLiteflowRetry();
            LiteflowMethod lfm = methodWrapBean.getLiteflowMethod();
            return lfr != null && lfm.value().isMainMethod();
        }).map(MethodWrapBean::getLiteflowRetry).findFirst().orElse(null);
        if (liteflowRetry != null) {
            beanClassAnnotation = (Annotation[])ArrayUtil.append((Object[])beanClassAnnotation, (Object[])new Annotation[]{liteflowRetry});
        }
        try {
            Object instance = new ByteBuddy().subclass(this.declWarpBean.getNodeType().getMappingClazz()).name(StrUtil.format((CharSequence)"{}$ByteBuddy${}${}", (Object[])new Object[]{this.declWarpBean.getRawClazz().getName(), this.declWarpBean.getNodeId(), SerialsUtil.generateShortUUID()})).implement((Type[])this.declWarpBean.getRawClazz().getInterfaces()).method((ElementMatcher)ElementMatchers.namedOneOf((String[])((String[])this.declWarpBean.getMethodWrapBeanList().stream().map(wrap -> wrap.getLiteflowMethod().value().getMethodName()).toArray(String[]::new)))).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)new AopInvocationHandler(this.declWarpBean))).annotateType((Annotation[])beanClassAnnotation).make().load(DeclComponentProxy.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().newInstance();
            NodeComponent nodeComponent = (NodeComponent)instance;
            nodeComponent.setNodeId(this.declWarpBean.getNodeId());
            nodeComponent.setName(this.declWarpBean.getNodeName());
            return nodeComponent;
        }
        catch (Exception e) {
            throw new ProxyException(e);
        }
    }

    public class AopInvocationHandler
    implements InvocationHandler {
        private DeclWarpBean declWarpBean;

        public AopInvocationHandler(DeclWarpBean declWarpBean) {
            this.declWarpBean = declWarpBean;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean checkFlag;
            MethodWrapBean currentMethodWrapBean = this.declWarpBean.getMethodWrapBeanList().stream().filter(methodWrapBean -> methodWrapBean.getLiteflowMethod().value().getMethodName().equals(method.getName())).findFirst().orElse(null);
            boolean bl = checkFlag = currentMethodWrapBean.getMethod().getParameterTypes().length > 0 && currentMethodWrapBean.getMethod().getParameterTypes()[0].equals(NodeComponent.class);
            if (!checkFlag) {
                String errMsg = StrUtil.format((CharSequence)"Method[{}.{}] must have NodeComponent parameter(first parameter is NodeComponent)", (Object[])new Object[]{this.declWarpBean.getRawClazz().getName(), currentMethodWrapBean.getMethod().getName()});
                DeclComponentProxy.this.LOG.error(errMsg);
                throw new ComponentMethodDefineErrorException(errMsg);
            }
            try {
                if (args != null && args.length > 0) {
                    Object[] wrapArgs = ArrayUtil.insert((Object[])args, (int)0, (Object[])new Object[]{proxy});
                    return ReflectUtil.invoke((Object)this.declWarpBean.getRawBean(), (Method)currentMethodWrapBean.getMethod(), (Object[])wrapArgs);
                }
                return ReflectUtil.invoke((Object)this.declWarpBean.getRawBean(), (Method)currentMethodWrapBean.getMethod(), (Object[])new Object[]{proxy});
            }
            catch (InvocationTargetRuntimeException e) {
                InvocationTargetException targetEx = (InvocationTargetException)e.getCause();
                throw targetEx.getTargetException();
            }
        }
    }
}

