/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.base;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import com.yomahub.liteflow.parser.base.FlowParser;
import com.yomahub.liteflow.parser.helper.ParserHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class BaseXmlFlowParser
implements FlowParser {
    private final Set<String> CHAIN_NAME_SET = new HashSet<String>();

    public void parse(String content) throws Exception {
        this.parse(ListUtil.toList((Object[])new String[]{content}));
    }

    @Override
    public void parse(List<String> contentList) throws Exception {
        if (CollectionUtil.isEmpty(contentList)) {
            return;
        }
        ArrayList documentList = ListUtil.toList((Object[])new Document[0]);
        for (String content : contentList) {
            Document document = DocumentHelper.parseText((String)content);
            documentList.add(document);
        }
        ParserHelper.parseNodeDocument(documentList);
        ParserHelper.parseChainDocument(documentList, this.CHAIN_NAME_SET, this::parseOneChain);
    }

    public abstract void parseOneChain(Element var1);
}

