/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.base;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.yomahub.liteflow.parser.base.FlowParser;
import com.yomahub.liteflow.parser.helper.ParserHelper;
import com.yomahub.liteflow.util.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class BaseJsonFlowParser
implements FlowParser {
    private final Set<String> CHAIN_NAME_SET = new CopyOnWriteArraySet<String>();

    public void parse(String content) throws Exception {
        this.parse(ListUtil.toList((Object[])new String[]{content}));
    }

    @Override
    public void parse(List<String> contentList) throws Exception {
        if (CollectionUtil.isEmpty(contentList)) {
            return;
        }
        ArrayList jsonObjectList = ListUtil.toList((Object[])new JsonNode[0]);
        for (String content : contentList) {
            JsonNode flowJsonNode = JsonUtil.parseObject(content);
            jsonObjectList.add(flowJsonNode);
        }
        ParserHelper.parseNodeJson(jsonObjectList);
        ParserHelper.parseChainJson(jsonObjectList, this.CHAIN_NAME_SET, this::parseOneChain);
    }

    public abstract void parseOneChain(JsonNode var1);
}

