/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core;

import cn.hutool.core.date.StopWatch;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.FlowExecutorHolder;
import com.yomahub.liteflow.core.proxy.LiteFlowProxyUtil;
import com.yomahub.liteflow.enums.CmpStepTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.flow.LiteflowResponse;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.entity.CmpStep;
import com.yomahub.liteflow.flow.executor.DefaultNodeExecutor;
import com.yomahub.liteflow.flow.executor.NodeExecutor;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.monitor.CompStatistics;
import com.yomahub.liteflow.monitor.MonitorBus;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.spi.holder.CmpAroundAspectHolder;
import com.yomahub.liteflow.util.JsonUtil;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Stack;

public abstract class NodeComponent {
    private final LFLog LOG = LFLoggerManager.getLogger(this.getClass());
    private MonitorBus monitorBus;
    private String nodeId;
    private String name;
    private NodeTypeEnum type;
    private NodeComponent self;
    private int retryCount = 0;
    private boolean isRollback = false;
    private Class<? extends Exception>[] retryForExceptions = new Class[]{Exception.class};
    private Class<? extends NodeExecutor> nodeExecutorClass = DefaultNodeExecutor.class;
    private final ThreadLocal<Stack<Node>> refNodeStackTL = new ThreadLocal();

    public NodeComponent() {
        Class<?> clazz = this.getClass();
        try {
            Method method = clazz.getDeclaredMethod("rollback", new Class[0]);
            if (ObjectUtil.isNotNull((Object)method)) {
                this.setRollback(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void execute() throws Exception {
        Slot slot = this.getSlot();
        CmpStep cmpStep = new CmpStep(this.nodeId, this.name, CmpStepTypeEnum.SINGLE);
        cmpStep.setTag(this.getTag());
        cmpStep.setInstance(this);
        cmpStep.setRefNode(this.getRefNode());
        cmpStep.setStartTime(new Date());
        slot.addStep(cmpStep);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.self.beforeProcess();
            this.self.process();
            this.self.onSuccess();
            cmpStep.setSuccess(true);
        }
        catch (Exception e) {
            cmpStep.setSuccess(false);
            cmpStep.setException(e);
            try {
                this.self.onError(e);
            }
            catch (Exception ex) {
                String errMsg = StrUtil.format((CharSequence)"component[{}] onError method happens exception", (Object[])new Object[]{this.getDisplayName()});
                this.LOG.error(errMsg, ex);
            }
            throw e;
        }
        finally {
            this.self.afterProcess();
            stopWatch.stop();
            long timeSpent = stopWatch.getTotalTimeMillis();
            this.LOG.info("component[{}] finished in {} milliseconds", (Object)this.getDisplayName(), (Object)timeSpent);
            cmpStep.setEndTime(new Date());
            cmpStep.setTimeSpent(timeSpent);
            if (ObjectUtil.isNotNull((Object)this.monitorBus)) {
                CompStatistics statistics = new CompStatistics(this.getClass().getSimpleName(), timeSpent);
                this.monitorBus.addStatistics(statistics);
            }
        }
    }

    public void doRollback() throws Exception {
        Slot slot = this.getSlot();
        boolean alreadyRollback = slot.getRollbackSteps().stream().anyMatch(cmpStep -> cmpStep.getRefNode().equals(this.getRefNode()));
        if (alreadyRollback) {
            return;
        }
        CmpStep cmpStep2 = new CmpStep(this.nodeId, this.name, CmpStepTypeEnum.SINGLE);
        cmpStep2.setTag(this.getTag());
        cmpStep2.setInstance(this);
        cmpStep2.setRefNode(this.getRefNode());
        slot.addRollbackStep(cmpStep2);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.self.rollback();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            stopWatch.stop();
            long timeSpent = stopWatch.getTotalTimeMillis();
            this.LOG.info("component[{}] rollback in {} milliseconds", (Object)this.getDisplayName(), (Object)timeSpent);
            cmpStep2.setRollbackTimeSpent(timeSpent);
        }
    }

    public void beforeProcess() {
        CmpAroundAspectHolder.loadCmpAroundAspect().beforeProcess(this.self);
    }

    public abstract void process() throws Exception;

    public void rollback() throws Exception {
    }

    public void onSuccess() throws Exception {
        CmpAroundAspectHolder.loadCmpAroundAspect().onSuccess(this.self);
    }

    public void onError(Exception e) throws Exception {
        CmpAroundAspectHolder.loadCmpAroundAspect().onError(this.self, e);
    }

    public void afterProcess() {
        CmpAroundAspectHolder.loadCmpAroundAspect().afterProcess(this.self);
    }

    public boolean isAccess() {
        return true;
    }

    public boolean isContinueOnError() {
        return false;
    }

    public boolean isEnd() {
        Boolean isEnd = this.getRefNode().getIsEnd();
        if (ObjectUtil.isNull((Object)isEnd)) {
            return false;
        }
        return isEnd;
    }

    public void setIsEnd(boolean isEnd) {
        this.getRefNode().setIsEnd(isEnd);
    }

    public void setIsContinueOnError(boolean isContinueOnError) {
        this.getRefNode().setIsContinueOnErrorResult(isContinueOnError);
    }

    public Integer getSlotIndex() {
        return this.getRefNode().getSlotIndex();
    }

    public Slot getSlot() {
        return DataBus.getSlot(this.getSlotIndex());
    }

    public <T> T getFirstContextBean() {
        return this.getSlot().getFirstContextBean();
    }

    public <T> T getContextBean(Class<T> contextBeanClazz) {
        return this.getSlot().getContextBean(contextBeanClazz);
    }

    public <T> T getContextBean(String contextName) {
        return this.getSlot().getContextBean(contextName);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public NodeComponent getSelf() {
        return this.self;
    }

    public void setSelf(NodeComponent self) {
        this.self = self;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NodeTypeEnum getType() {
        return this.type;
    }

    public void setType(NodeTypeEnum type) {
        this.type = type;
    }

    public <T> void sendPrivateDeliveryData(String nodeId, T t) {
        this.getSlot().setPrivateDeliveryData(nodeId, t);
    }

    public <T> T getPrivateDeliveryData() {
        return this.getSlot().getPrivateDeliveryData(this.getNodeId());
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public Class<? extends Exception>[] getRetryForExceptions() {
        return this.retryForExceptions;
    }

    public void setRetryForExceptions(Class<? extends Exception>[] retryForExceptions) {
        this.retryForExceptions = retryForExceptions;
    }

    public Class<? extends NodeExecutor> getNodeExecutorClass() {
        return this.nodeExecutorClass;
    }

    public void setNodeExecutorClass(Class<? extends NodeExecutor> nodeExecutorClass) {
        this.nodeExecutorClass = nodeExecutorClass;
    }

    public String getTag() {
        return this.getRefNode().getTag();
    }

    public MonitorBus getMonitorBus() {
        return this.monitorBus;
    }

    public void setMonitorBus(MonitorBus monitorBus) {
        this.monitorBus = monitorBus;
    }

    public <T> T getRequestData() {
        return this.getSlot().getRequestData();
    }

    public <T> T getSubChainReqData() {
        return this.getSlot().getChainReqData(this.getCurrChainId());
    }

    public <T> T getSubChainReqDataInAsync() {
        return this.getSlot().getChainReqDataFromQueue(this.getCurrChainId());
    }

    public boolean isRollback() {
        return this.isRollback;
    }

    public void setRollback(boolean rollback) {
        this.isRollback = rollback;
    }

    @Deprecated
    public String getChainName() {
        return this.getSlot().getChainName();
    }

    public String getChainId() {
        return this.getSlot().getChainId();
    }

    public String getDisplayName() {
        if (StrUtil.isEmpty((CharSequence)this.name)) {
            return this.nodeId;
        }
        return StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{this.nodeId, this.name});
    }

    public String getCurrChainId() {
        return this.getRefNode().getCurrChainId();
    }

    public Node getRefNode() {
        return this.refNodeStackTL.get().peek();
    }

    public void setRefNode(Node refNode) {
        if (this.refNodeStackTL.get() == null) {
            Stack<Node> stack = new Stack<Node>();
            stack.push(refNode);
            this.refNodeStackTL.set(stack);
        } else {
            Node compareNode = this.refNodeStackTL.get().peek();
            if (!compareNode.equals(refNode)) {
                this.refNodeStackTL.get().push(refNode);
            }
        }
    }

    public void removeRefNode() {
        if (this.refNodeStackTL.get().size() > 1) {
            this.refNodeStackTL.get().pop();
        } else {
            this.refNodeStackTL.remove();
        }
    }

    public <T> T getCmpData(Class<T> clazz) {
        String cmpData = this.getRefNode().getCmpData();
        if (StrUtil.isBlank((CharSequence)cmpData)) {
            return null;
        }
        if (clazz.equals(String.class) || clazz.equals(Object.class)) {
            return (T)cmpData;
        }
        return JsonUtil.parseObject(cmpData, clazz);
    }

    public <T> List<T> getCmpDataList(Class<T> clazz) {
        String cmpData = this.getRefNode().getCmpData();
        if (StrUtil.isBlank((CharSequence)cmpData)) {
            return null;
        }
        return JsonUtil.parseList(cmpData, clazz);
    }

    public Integer getLoopIndex() {
        return this.getRefNode().getLoopIndex();
    }

    public Integer getPreLoopIndex() {
        return this.getRefNode().getPreLoopIndex();
    }

    public Integer getPreNLoopIndex(int n) {
        return this.getRefNode().getPreNLoopIndex(n);
    }

    public <T> T getCurrLoopObj() {
        return this.getRefNode().getCurrLoopObject();
    }

    public <T> T getPreLoopObj() {
        return this.getRefNode().getPreLoopObject();
    }

    public <T> T getPreNLoopObj(int n) {
        return this.getRefNode().getPreNLoopObject(n);
    }

    @Deprecated
    public void invoke(String chainId, Object param) throws Exception {
        FlowExecutorHolder.loadInstance().invoke(chainId, param, this.getSlotIndex());
    }

    public LiteflowResponse invoke2Resp(String chainId, Object param) {
        return FlowExecutorHolder.loadInstance().invoke2Resp(chainId, param, this.getSlotIndex());
    }

    @Deprecated
    public void invokeInAsync(String chainId, Object param) throws Exception {
        FlowExecutorHolder.loadInstance().invokeInAsync(chainId, param, this.getSlotIndex());
    }

    public LiteflowResponse invoke2RespInAsync(String chainId, Object param) {
        return FlowExecutorHolder.loadInstance().invoke2RespInAsync(chainId, param, this.getSlotIndex());
    }

    public <T> T getItemResultMetaValue(Integer slotIndex) {
        return null;
    }

    protected String getMetaValueKey() {
        Class<?> originalClass = LiteFlowProxyUtil.getUserClass(this.getClass());
        return originalClass.getName();
    }
}

