/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.script.jsr223;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.script.ScriptExecuteWrap;
import com.yomahub.liteflow.script.ScriptExecutor;
import com.yomahub.liteflow.script.exception.ScriptLoadException;
import com.yomahub.liteflow.util.CopyOnWriteHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public abstract class JSR223ScriptExecutor
extends ScriptExecutor {
    protected final LFLog LOG = LFLoggerManager.getLogger(this.getClass());
    private ScriptEngine scriptEngine;
    private final Map<String, CompiledScript> compiledScriptMap = new CopyOnWriteHashMap<String, CompiledScript>();

    @Override
    public ScriptExecutor init() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        this.scriptEngine = scriptEngineManager.getEngineByName(this.scriptType().getEngineName());
        super.lifeCycle(this.scriptEngine);
        return this;
    }

    protected String convertScript(String script) {
        return script;
    }

    @Override
    public void load(String nodeId, String script) {
        try {
            this.compiledScriptMap.put(nodeId, (CompiledScript)this.compile(script));
        }
        catch (Exception e) {
            String errorMsg = StrUtil.format((CharSequence)"script loading error for node[{}], error msg:{}", (Object[])new Object[]{nodeId, e.getMessage()});
            throw new ScriptLoadException(errorMsg);
        }
    }

    @Override
    public void unLoad(String nodeId) {
        this.compiledScriptMap.remove(nodeId);
    }

    @Override
    public List<String> getNodeIds() {
        return new ArrayList<String>(this.compiledScriptMap.keySet());
    }

    @Override
    public Object executeScript(ScriptExecuteWrap wrap) throws Exception {
        if (!this.compiledScriptMap.containsKey(wrap.getNodeId())) {
            String errorMsg = StrUtil.format((CharSequence)"script for node[{}] is not loaded", (Object[])new Object[]{wrap.getNodeId()});
            throw new ScriptLoadException(errorMsg);
        }
        CompiledScript compiledScript = this.compiledScriptMap.get(wrap.getNodeId());
        SimpleBindings bindings = new SimpleBindings();
        this.bindParam(wrap, bindings::put, bindings::putIfAbsent);
        return compiledScript.eval(bindings);
    }

    @Override
    public void cleanCache() {
        this.compiledScriptMap.clear();
    }

    @Override
    public Object compile(String script) throws ScriptException {
        if (this.scriptEngine == null) {
            this.LOG.error("script engine has not init");
        }
        return ((Compilable)((Object)this.scriptEngine)).compile(this.convertScript(script));
    }
}

