/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el.operator;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.StrFormatter;
import com.ql.util.express.exception.QLException;
import com.yomahub.liteflow.builder.el.operator.base.BaseOperator;
import com.yomahub.liteflow.builder.el.operator.base.OperatorHelper;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.condition.FinallyCondition;
import com.yomahub.liteflow.flow.element.condition.ThenCondition;
import com.yomahub.liteflow.flow.element.condition.TimeoutCondition;
import com.yomahub.liteflow.flow.element.condition.WhenCondition;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class MaxWaitTimeOperator
extends BaseOperator<Condition> {
    @Override
    public Condition build(Object[] objects) throws Exception {
        OperatorHelper.checkObjectSizeEqTwo(objects);
        Executable executable = OperatorHelper.convert(objects[0], Executable.class);
        Integer maxWaitTime = OperatorHelper.convert(objects[1], Integer.class);
        if (executable instanceof WhenCondition) {
            WhenCondition whenCondition = OperatorHelper.convert(executable, WhenCondition.class);
            whenCondition.setMaxWaitTime(maxWaitTime);
            whenCondition.setMaxWaitTimeUnit(this.getMaxWaitTimeUnit());
            return whenCondition;
        }
        if (executable instanceof FinallyCondition) {
            String errorMsg = StrFormatter.format((String)"The caller [{}] cannot use the keyword \"{}'\"", (Object[])new Object[]{executable.toString(), this.operatorName()});
            throw new QLException(errorMsg);
        }
        if (this.containsFinally(executable)) {
            ThenCondition thenCondition = OperatorHelper.convert(executable, ThenCondition.class);
            return this.handleFinally(thenCondition, maxWaitTime);
        }
        return this.wrappedByTimeout(executable, maxWaitTime);
    }

    private TimeoutCondition wrappedByTimeout(Executable executable, Integer maxWaitTime) {
        TimeoutCondition timeoutCondition = new TimeoutCondition();
        timeoutCondition.addExecutable(executable);
        timeoutCondition.setMaxWaitTime(maxWaitTime);
        timeoutCondition.setMaxWaitTimeUnit(this.getMaxWaitTimeUnit());
        timeoutCondition.setId(executable.getId());
        timeoutCondition.setTag(executable.getTag());
        return timeoutCondition;
    }

    private boolean containsFinally(Executable executable) {
        return executable instanceof ThenCondition && CollUtil.isNotEmpty(((ThenCondition)executable).getFinallyConditionList());
    }

    private ThenCondition handleFinally(ThenCondition thenCondition, Integer maxWaitTime) {
        ThenCondition outerThenCondition = new ThenCondition();
        List<Executable> finallyList = thenCondition.getExecutableList("FINALLY_KEY");
        finallyList.forEach(executable -> outerThenCondition.addFinallyCondition((FinallyCondition)executable));
        finallyList.clear();
        TimeoutCondition whenCondition = this.wrappedByTimeout(thenCondition, maxWaitTime);
        outerThenCondition.addExecutable(whenCondition);
        return outerThenCondition;
    }

    abstract TimeUnit getMaxWaitTimeUnit();

    abstract String operatorName();
}

