/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.enums.ExecuteableTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.exception.FlowSystemException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Rollbackable;
import com.yomahub.liteflow.flow.element.condition.LoopCondition;
import com.yomahub.liteflow.flow.executor.NodeExecutor;
import com.yomahub.liteflow.flow.executor.NodeExecutorHelper;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.util.TupleOf2;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;

public class Node
implements Executable,
Cloneable,
Rollbackable {
    private static final LFLog LOG = LFLoggerManager.getLogger(Node.class);
    private String id;
    private String nodeInstanceId;
    private String name;
    private String clazz;
    private NodeTypeEnum type;
    private String script;
    private String language;
    @JsonIgnore
    private NodeComponent instance;
    private String tag;
    private String cmpData;
    private Map<String, String> bindDataMap = new HashMap<String, String>();
    private String currChainId;
    private boolean isCompiled = true;
    private boolean isCloned = false;
    private TransmittableThreadLocal<Boolean> accessResult = new TransmittableThreadLocal();
    private TransmittableThreadLocal<Stack<TupleOf2<Integer, Integer>>> loopIndexTL = new TransmittableThreadLocal();
    private TransmittableThreadLocal<Stack<TupleOf2<Integer, Object>>> loopObjectTL = new TransmittableThreadLocal();
    private TransmittableThreadLocal<Integer> slotIndexTL = new TransmittableThreadLocal();
    private TransmittableThreadLocal<Boolean> isEndTL = new TransmittableThreadLocal();
    private TransmittableThreadLocal<Boolean> isContinueOnErrorResult = new TransmittableThreadLocal();
    private ThreadLocal<Object> stepDataTL = new ThreadLocal();
    private ReentrantLock lock4LoopIndex = new ReentrantLock();
    private ReentrantLock lock4LoopObj = new ReentrantLock();

    public Node() {
    }

    public Node(NodeComponent instance) {
        this.id = instance.getNodeId();
        this.name = instance.getName();
        this.instance = instance;
        this.type = instance.getType();
        this.clazz = instance.getClass().getName();
    }

    public Node(String nodeId, String name, NodeTypeEnum nodeType, String script, String language) {
        this.id = nodeId;
        this.name = name;
        this.type = nodeType;
        this.script = script;
        this.language = language;
        this.isCompiled = false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getNodeInstanceId() {
        return this.nodeInstanceId;
    }

    public void setNodeInstanceId(String nodeInstanceId) {
        this.nodeInstanceId = nodeInstanceId;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void setTag(String tag) {
        this.tag = tag;
        if (BooleanUtil.isFalse((Boolean)this.isCloned)) {
            this.setCloned(true);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NodeTypeEnum getType() {
        return this.type;
    }

    public void setType(NodeTypeEnum type) {
        this.type = type;
    }

    public NodeComponent getInstance() {
        if (!this.isCompiled()) {
            this.instance = FlowBus.addScriptNodeAndCompile(this.id, this.name, this.type, this.script, this.language);
        }
        return this.instance;
    }

    public void setInstance(NodeComponent instance) {
        this.instance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Integer slotIndex) throws Exception {
        block13: {
            if (ObjectUtil.isNull((Object)this.getInstance())) {
                throw new FlowSystemException("there is no instance for node id " + this.id);
            }
            try {
                this.setSlotIndex(slotIndex);
                this.instance.setRefNode(this);
                if (this.getAccessResult() || this.instance.isAccess()) {
                    NodeExecutor nodeExecutor = NodeExecutorHelper.loadInstance().buildNodeExecutor(this.instance.getNodeExecutorClass());
                    nodeExecutor.execute(this.instance);
                    if (this.type.isScript() && !this.isCompiled) {
                        this.setCompiled(true);
                    }
                } else {
                    LOG.info("[X]skip component[{}] execution", (Object)this.instance.getDisplayName());
                }
                if (this.instance.isEnd()) {
                    String errorInfo = StrUtil.format((CharSequence)"[{}] lead the chain to end", (Object[])new Object[]{this.instance.getDisplayName()});
                    throw new ChainEndException(errorInfo);
                }
            }
            catch (Exception e) {
                if (e instanceof ChainEndException) {
                    throw e;
                }
                if (this.instance.isEnd()) {
                    String errorInfo = StrUtil.format((CharSequence)"[{}] lead the chain to end", (Object[])new Object[]{this.instance.getDisplayName()});
                    throw new ChainEndException(errorInfo);
                }
                if (this.getIsContinueOnErrorResult() || this.instance.isContinueOnError()) {
                    String errorMsg = StrUtil.format((CharSequence)"component[{}] cause error,but flow is still go on", (Object[])new Object[]{this.id});
                    LOG.error(errorMsg);
                    break block13;
                }
                String errorMsg = StrUtil.format((CharSequence)"component[{}] cause error,error:{}", (Object[])new Object[]{this.id, e.getMessage()});
                LOG.error(errorMsg);
                throw e;
            }
            finally {
                this.getInstance().removeRefNode();
                this.removeSlotIndex();
                this.removeIsEnd();
                this.removeLoopIndex();
                this.removeAccessResult();
                this.removeIsContinueOnErrorResult();
                this.removeStepData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Integer slotIndex) throws Exception {
        try {
            this.setSlotIndex(slotIndex);
            this.getInstance().setRefNode(this);
            this.instance.doRollback();
        }
        catch (Exception e) {
            String errorMsg = StrUtil.format((CharSequence)"component[{}] rollback error,error:{}", (Object[])new Object[]{this.id, e.getMessage()});
            LOG.error(errorMsg);
        }
        finally {
            this.removeSlotIndex();
            this.instance.removeRefNode();
        }
    }

    @Override
    public boolean isAccess(Integer slotIndex) throws Exception {
        this.setSlotIndex(slotIndex);
        this.getInstance().setRefNode(this);
        return this.instance.isAccess();
    }

    @Override
    public ExecuteableTypeEnum getExecuteType() {
        return ExecuteableTypeEnum.NODE;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getCmpData() {
        return this.cmpData;
    }

    public void setCmpData(String cmpData) {
        this.cmpData = cmpData;
        if (BooleanUtil.isFalse((Boolean)this.isCloned)) {
            this.setCloned(true);
        }
    }

    @Override
    public void setCurrChainId(String currentChainId) {
        this.currChainId = currentChainId;
    }

    public String getCurrChainId() {
        return this.currChainId;
    }

    public boolean getAccessResult() {
        Boolean result = (Boolean)this.accessResult.get();
        return result != null && result != false;
    }

    public void setAccessResult(boolean accessResult) {
        this.accessResult.set((Object)accessResult);
    }

    public void removeAccessResult() {
        this.accessResult.remove();
    }

    public boolean getIsContinueOnErrorResult() {
        Boolean result = (Boolean)this.isContinueOnErrorResult.get();
        return result != null && result != false;
    }

    public void setIsContinueOnErrorResult(boolean accessResult) {
        this.isContinueOnErrorResult.set((Object)accessResult);
    }

    public void removeIsContinueOnErrorResult() {
        this.isContinueOnErrorResult.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoopIndex(LoopCondition condition, int index) {
        try {
            this.lock4LoopIndex.lock();
            if (this.loopIndexTL.get() == null) {
                Stack<TupleOf2<Integer, Integer>> stack = new Stack<TupleOf2<Integer, Integer>>();
                TupleOf2<Integer, Integer> tuple2 = new TupleOf2<Integer, Integer>(condition.hashCode(), index);
                stack.push(tuple2);
                this.loopIndexTL.set(stack);
            } else {
                Stack stack = (Stack)this.loopIndexTL.get();
                TupleOf2 thisConditionTuple = stack.stream().filter(tuple -> ((Integer)tuple.getA()).equals(condition.hashCode())).findFirst().orElse(null);
                if (thisConditionTuple != null) {
                    thisConditionTuple.setB(index);
                } else {
                    TupleOf2<Integer, Integer> tuple3 = new TupleOf2<Integer, Integer>(condition.hashCode(), index);
                    stack.push(tuple3);
                }
            }
        }
        finally {
            this.lock4LoopIndex.unlock();
        }
    }

    public Integer getLoopIndex() {
        Stack stack = (Stack)this.loopIndexTL.get();
        if (stack != null) {
            return (Integer)((TupleOf2)stack.peek()).getB();
        }
        return null;
    }

    public Integer getPreLoopIndex() {
        return this.getPreNLoopIndex(1);
    }

    public Integer getPreNLoopIndex(int n) {
        Stack stack = (Stack)this.loopIndexTL.get();
        if (stack != null && stack.size() > n) {
            return (Integer)((TupleOf2)stack.elementAt(stack.size() - (n + 1))).getB();
        }
        return null;
    }

    public void removeLoopIndex() {
        try {
            this.lock4LoopIndex.lock();
            Stack stack = (Stack)this.loopIndexTL.get();
            if (stack != null) {
                if (stack.size() > 1) {
                    stack.pop();
                } else {
                    this.loopIndexTL.remove();
                }
            }
        }
        finally {
            this.lock4LoopIndex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrLoopObject(LoopCondition condition, Object obj) {
        try {
            this.lock4LoopObj.lock();
            if (this.loopObjectTL.get() == null) {
                Stack<TupleOf2<Integer, Object>> stack = new Stack<TupleOf2<Integer, Object>>();
                TupleOf2<Integer, Object> tuple2 = new TupleOf2<Integer, Object>(condition.hashCode(), obj);
                stack.push(tuple2);
                this.loopObjectTL.set(stack);
            } else {
                Stack stack = (Stack)this.loopObjectTL.get();
                TupleOf2 thisConditionTuple = stack.stream().filter(tuple -> ((Integer)tuple.getA()).equals(condition.hashCode())).findFirst().orElse(null);
                if (thisConditionTuple != null) {
                    thisConditionTuple.setB(obj);
                } else {
                    TupleOf2<Integer, Object> tuple3 = new TupleOf2<Integer, Object>(condition.hashCode(), obj);
                    stack.push(tuple3);
                }
            }
        }
        finally {
            this.lock4LoopObj.unlock();
        }
    }

    public <T> T getCurrLoopObject() {
        Stack stack = (Stack)this.loopObjectTL.get();
        if (stack != null) {
            return (T)((TupleOf2)stack.peek()).getB();
        }
        return null;
    }

    public <T> T getPreLoopObject() {
        return this.getPreNLoopObject(1);
    }

    public <T> T getPreNLoopObject(int n) {
        Stack stack = (Stack)this.loopObjectTL.get();
        if (stack != null && stack.size() > n) {
            return (T)((TupleOf2)stack.elementAt(stack.size() - (n + 1))).getB();
        }
        return null;
    }

    public void removeCurrLoopObject() {
        try {
            this.lock4LoopObj.lock();
            Stack stack = (Stack)this.loopObjectTL.get();
            if (stack != null) {
                if (stack.size() > 1) {
                    stack.pop();
                } else {
                    this.loopObjectTL.remove();
                }
            }
        }
        finally {
            this.lock4LoopObj.unlock();
        }
    }

    public Integer getSlotIndex() {
        return (Integer)this.slotIndexTL.get();
    }

    public void setSlotIndex(Integer slotIndex) {
        this.slotIndexTL.set((Object)slotIndex);
    }

    public void removeSlotIndex() {
        this.slotIndexTL.remove();
    }

    public Boolean getIsEnd() {
        return (Boolean)this.isEndTL.get();
    }

    public void setIsEnd(Boolean isEnd) {
        this.isEndTL.set((Object)isEnd);
    }

    public void removeIsEnd() {
        this.isEndTL.remove();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    public void setCompiled(boolean compiled) {
        this.isCompiled = compiled;
    }

    @Override
    public <T> T getItemResultMetaValue(Integer slotIndex) {
        return this.getInstance().getItemResultMetaValue(slotIndex);
    }

    public void putBindData(String key, String value) {
        this.bindDataMap.put(key, value);
        if (BooleanUtil.isFalse((Boolean)this.isCloned)) {
            this.setCloned(true);
        }
    }

    public String getBindData(String key) {
        return this.bindDataMap.get(key);
    }

    public boolean isCloned() {
        return this.isCloned;
    }

    public void setCloned(boolean cloned) {
        this.isCloned = cloned;
    }

    public Object getStepData() {
        return this.stepDataTL.get();
    }

    public void setStepData(Object stepData) {
        this.stepDataTL.set(stepData);
    }

    public void removeStepData() {
        this.stepDataTL.remove();
    }

    public Node clone() throws CloneNotSupportedException {
        Node node = (Node)super.clone();
        node.loopIndexTL = new TransmittableThreadLocal();
        node.loopObjectTL = new TransmittableThreadLocal();
        node.accessResult = new TransmittableThreadLocal();
        node.slotIndexTL = new TransmittableThreadLocal();
        node.isEndTL = new TransmittableThreadLocal();
        node.isContinueOnErrorResult = new TransmittableThreadLocal();
        node.stepDataTL = new ThreadLocal();
        node.lock4LoopIndex = new ReentrantLock();
        node.lock4LoopObj = new ReentrantLock();
        node.bindDataMap = new HashMap<String, String>();
        return node;
    }
}

