/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core;

import com.yomahub.liteflow.core.NodeForComponent;
import com.yomahub.liteflow.core.ScriptComponent;
import com.yomahub.liteflow.enums.ScriptTypeEnum;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.script.ScriptExecuteWrap;
import com.yomahub.liteflow.script.ScriptExecutor;
import com.yomahub.liteflow.script.ScriptExecutorFactory;

public class ScriptForComponent
extends NodeForComponent
implements ScriptComponent {
    private final LFLog LOG = LFLoggerManager.getLogger(this.getClass());
    private ScriptExecutor scriptExecutor;

    @Override
    public int processFor() throws Exception {
        ScriptExecuteWrap wrap = this.buildWrap(this);
        return (Integer)this.scriptExecutor.execute(wrap);
    }

    @Override
    public void loadScript(String script, String language) {
        this.LOG.info("load script for component[{}]", (Object)this.getDisplayName());
        this.scriptExecutor = ScriptExecutorFactory.loadInstance().getScriptExecutor(language);
        this.scriptExecutor.load(this.getNodeId(), script);
    }

    @Override
    public boolean isAccess() {
        ScriptExecuteWrap wrap = this.buildWrap(this);
        return this.scriptExecutor.executeIsAccess(wrap);
    }

    @Override
    public boolean isContinueOnError() {
        ScriptExecuteWrap wrap = this.buildWrap(this);
        return this.scriptExecutor.executeIsContinueOnError(wrap);
    }

    @Override
    public boolean isEnd() {
        if (!ScriptTypeEnum.JAVA.getDisplayName().equals(this.getRefNode().getLanguage())) {
            return super.isEnd();
        }
        ScriptExecuteWrap wrap = this.buildWrap(this);
        return this.scriptExecutor.executeIsEnd(wrap);
    }

    @Override
    public void beforeProcess() {
        ScriptExecuteWrap wrap = this.buildWrap(this);
        this.scriptExecutor.executeBeforeProcess(wrap);
    }

    @Override
    public void afterProcess() {
        ScriptExecuteWrap wrap = this.buildWrap(this);
        this.scriptExecutor.executeAfterProcess(wrap);
    }

    @Override
    public void onSuccess() throws Exception {
        ScriptExecuteWrap wrap = this.buildWrap(this);
        this.scriptExecutor.executeOnSuccess(wrap);
    }

    @Override
    public void onError(Exception e) throws Exception {
        ScriptExecuteWrap wrap = this.buildWrap(this);
        this.scriptExecutor.executeOnError(wrap, e);
    }

    @Override
    public void rollback() throws Exception {
        ScriptExecuteWrap wrap = this.buildWrap(this);
        this.scriptExecutor.executeRollback(wrap);
    }
}

