/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el.operator.base;

import cn.hutool.core.util.StrUtil;
import com.ql.util.express.exception.QLException;
import com.yomahub.liteflow.flow.element.Node;
import java.util.Objects;

public class OperatorHelper {
    public static void checkObjectSizeNeqOne(Object[] objects) throws QLException {
        OperatorHelper.checkObjectSizeNeq(objects, 1);
    }

    public static void checkObjectSizeNeq(Object[] objects, int size) throws QLException {
        OperatorHelper.checkObjectSizeGtZero(objects);
        if (objects.length != size) {
            throw new QLException("parameter error");
        }
    }

    public static void checkObjectSizeGtZero(Object[] objects) throws QLException {
        if (objects.length == 0) {
            throw new QLException("parameter is empty");
        }
    }

    public static void checkObjectSizeGtTwo(Object[] objects) throws QLException {
        OperatorHelper.checkObjectSizeGtZero(objects);
        if (objects.length <= 1) {
            throw new QLException("parameter error");
        }
    }

    public static void checkObjectSizeEqTwo(Object[] objects) throws QLException {
        OperatorHelper.checkObjectSizeEq(objects, 2);
    }

    public static void checkObjectSizeEqThree(Object[] objects) throws QLException {
        OperatorHelper.checkObjectSizeEq(objects, 3);
    }

    public static void checkObjectSizeEq(Object[] objects, int size) throws QLException {
        OperatorHelper.checkObjectSizeGtZero(objects);
        if (objects.length != size) {
            throw new QLException("parameter error");
        }
    }

    public static void checkObjectSizeEq(Object[] objects, int size1, int size2) throws QLException {
        OperatorHelper.checkObjectSizeGtZero(objects);
        if (objects.length != size1 && objects.length != size2) {
            throw new QLException("parameter error");
        }
    }

    public static <T> T convert(Object object, Class<T> clazz) throws QLException {
        String errorMsg = StrUtil.format((CharSequence)"The parameter must be {} item", (Object[])new Object[]{clazz.getSimpleName()});
        return OperatorHelper.convert(object, clazz, errorMsg);
    }

    public static <T> T convert(Object object, Class<T> clazz, String errorMsg) throws QLException {
        try {
            if (clazz.isAssignableFrom(object.getClass())) {
                if (clazz.equals(Node.class)) {
                    Node node = (Node)object;
                    return (T)node.copy();
                }
                return (T)object;
            }
        }
        catch (Exception e) {
            throw new QLException("An error occurred while copying an object");
        }
        throw new QLException(errorMsg);
    }

    public static void checkNodeAndChainExist(Object[] objects) throws QLException {
        for (Object object : objects) {
            if (!Objects.isNull(object)) continue;
            throw new QLException("DataNofFoundException");
        }
    }
}

