/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.script.proxy;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.exception.LiteFlowException;
import com.yomahub.liteflow.exception.ScriptBeanMethodInvokeException;
import com.yomahub.liteflow.script.proxy.ScriptBeanProxy;
import com.yomahub.liteflow.util.LiteFlowProxyUtil;
import com.yomahub.liteflow.util.SerialsUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ScriptMethodProxy {
    private final Object bean;
    private final Class<?> orignalClass;
    private final List<Method> scriptMethods;

    public ScriptMethodProxy(Object bean, Class<?> orignalClass, List<Method> scriptMethods) {
        this.bean = bean;
        this.orignalClass = orignalClass;
        this.scriptMethods = scriptMethods;
    }

    public Object getProxyScriptMethod() {
        try {
            return new ByteBuddy().subclass(this.orignalClass).name(this.buildClassName()).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)new AopInvocationHandler(this.bean, this.scriptMethods))).annotateType(this.orignalClass.getAnnotations()).make().load(ScriptBeanProxy.class.getClassLoader()).getLoaded().newInstance();
        }
        catch (Exception e) {
            throw new LiteFlowException(e);
        }
    }

    private String buildClassName() {
        return StrUtil.format((CharSequence)"{}.ByteBuddy${}", (Object[])new Object[]{ClassUtil.getPackage(this.orignalClass), SerialsUtil.generateShortUUID()});
    }

    public static class AopInvocationHandler
    implements InvocationHandler {
        private final Object bean;
        private final Class<?> clazz;
        private final Set<Method> methodSet;

        public AopInvocationHandler(Object bean, List<Method> methods) {
            this.bean = bean;
            this.clazz = LiteFlowProxyUtil.getUserClass(bean.getClass());
            this.methodSet = new HashSet<Method>(methods);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Optional<Method> invokeMethodOp = Arrays.stream(this.clazz.getMethods()).filter(method::equals).findFirst();
            if (!invokeMethodOp.isPresent()) {
                String errorMsg = StrUtil.format((CharSequence)"cannot find method[{}]", (Object[])new Object[]{this.clazz.getName(), method.getName()});
                throw new ScriptBeanMethodInvokeException(errorMsg);
            }
            if (!this.methodSet.contains(method)) {
                String errorMsg = StrUtil.format((CharSequence)"script method[{}.{}] cannot be executed", (Object[])new Object[]{this.clazz.getName(), method.getName()});
                throw new ScriptBeanMethodInvokeException(errorMsg);
            }
            return invokeMethodOp.get().invoke(this.bean, args);
        }
    }
}

