/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.spi.local;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.exception.ConfigErrorException;
import com.yomahub.liteflow.spi.PathContentParser;
import java.util.ArrayList;
import java.util.List;

public class LocalPathContentParser
implements PathContentParser {
    private static final String FILE_URL_PREFIX = "file:";
    private static final String CLASSPATH_URL_PREFIX = "classpath:";

    @Override
    public List<String> parseContent(List<String> pathList) throws Exception {
        if (CollectionUtil.isEmpty(pathList)) {
            throw new ConfigErrorException("rule source must not be null");
        }
        ArrayList<String> contentList = new ArrayList<String>();
        for (String path : pathList) {
            String content;
            if (FileUtil.isAbsolutePath((String)path) && FileUtil.isFile((String)path)) {
                path = FILE_URL_PREFIX + path;
            } else if (!path.startsWith(CLASSPATH_URL_PREFIX)) {
                path = CLASSPATH_URL_PREFIX + path;
            }
            if (!StrUtil.isNotBlank((CharSequence)(content = ResourceUtil.readUtf8Str((String)path)))) continue;
            contentList.add(content);
        }
        return contentList;
    }

    @Override
    public int priority() {
        return 2;
    }
}

