/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.util.JsonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class ELWrapper {
    private final List<ELWrapper> elWrapperList = new ArrayList<ELWrapper>();
    private String tag;
    private String id;
    private String dataName;
    private String data;
    private Integer maxWaitSeconds;

    protected void addWrapper(ELWrapper wrapper) {
        this.elWrapperList.add(wrapper);
    }

    protected void addWrapper(ELWrapper ... wrappers) {
        this.elWrapperList.addAll(Arrays.asList(wrappers));
    }

    protected void addWrapper(ELWrapper wrapper, int index) {
        this.elWrapperList.add(index, wrapper);
    }

    protected void setWrapper(ELWrapper wrapper, int index) {
        this.elWrapperList.set(index, wrapper);
    }

    protected ELWrapper getFirstWrapper() {
        return this.elWrapperList.get(0);
    }

    protected List<ELWrapper> getElWrapperList() {
        return this.elWrapperList;
    }

    protected void setTag(String tag) {
        this.tag = tag;
    }

    protected String getTag() {
        return this.tag;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected String getId() {
        return this.id;
    }

    protected void setData(String data) {
        this.data = data;
    }

    protected String getData() {
        return this.data;
    }

    protected void setDataName(String dataName) {
        this.dataName = dataName;
    }

    protected String getDataName() {
        return this.dataName;
    }

    protected void setMaxWaitSeconds(Integer maxWaitSeconds) {
        this.maxWaitSeconds = maxWaitSeconds;
    }

    protected Integer getMaxWaitSeconds() {
        return this.maxWaitSeconds;
    }

    public ELWrapper tag(String tag) {
        this.setTag(tag);
        return this;
    }

    public ELWrapper id(String id) {
        this.setId(id);
        return this;
    }

    protected ELWrapper data(String dataName, Object object) {
        this.setData("'" + JsonUtil.toJsonString((Object)object) + "'");
        this.setDataName(dataName);
        return this;
    }

    protected ELWrapper data(String dataName, String jsonString) {
        this.setData(jsonString);
        this.setDataName(dataName);
        return this;
    }

    protected ELWrapper data(String dataName, Map<String, Object> jsonMap) {
        this.setData("'" + JsonUtil.toJsonString(jsonMap) + "'");
        this.setDataName(dataName);
        return this;
    }

    protected ELWrapper maxWaitSeconds(Integer maxWaitSeconds) {
        this.setMaxWaitSeconds(maxWaitSeconds);
        return this;
    }

    public String toEL() {
        StringBuilder paramContext = new StringBuilder();
        String elContext = this.toEL(null, paramContext);
        return paramContext.append(elContext).append(";").toString();
    }

    public String toEL(boolean format) {
        StringBuilder paramContext = new StringBuilder();
        String elContext = !format ? this.toEL(null, paramContext) : this.toEL(0, paramContext);
        return paramContext.append(elContext).append(";").toString();
    }

    protected abstract String toEL(Integer var1, StringBuilder var2);

    protected void processWrapperProperty(StringBuilder elContext, StringBuilder paramContext) {
        if (this.getId() != null) {
            elContext.append(StrUtil.format((CharSequence)".id(\"{}\")", (Object[])new Object[]{this.getId()}));
        }
        if (this.getTag() != null) {
            elContext.append(StrUtil.format((CharSequence)".tag(\"{}\")", (Object[])new Object[]{this.getTag()}));
        }
        if (this.getMaxWaitSeconds() != null) {
            elContext.append(StrUtil.format((CharSequence)".maxWaitSeconds({})", (Object[])new Object[]{String.valueOf(this.getMaxWaitSeconds())}));
        }
    }

    protected void processWrapperNewLine(StringBuilder elContext, Integer depth) {
        if (depth != null) {
            elContext.append("\n");
        }
    }

    protected void processWrapperTabs(StringBuilder elContext, Integer depth) {
        if (depth != null) {
            elContext.append(StrUtil.repeat((CharSequence)"\t", (int)depth));
        }
    }

    protected void checkMaxWaitSeconds() {
        for (ELWrapper sonElWrapper : this.getElWrapperList()) {
            if (sonElWrapper == null || sonElWrapper.getMaxWaitSeconds() == null) continue;
            throw new IllegalArgumentException("maxWaitSeconds\u5fc5\u987b\u5b9a\u4e49\u5728\u5b8c\u6574\u7684\u8bed\u4e49\u4e4b\u540e\uff01");
        }
    }
}

