/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el;

import com.yomahub.liteflow.builder.el.ELBus;
import com.yomahub.liteflow.builder.el.ELWrapper;

public abstract class LoopELWrapper
extends ELWrapper {
    protected Integer loopNumber;
    protected String loopFunction;
    protected boolean parallel;

    public LoopELWrapper(Integer loopNumber, String loopFunction) {
        this.loopNumber = loopNumber;
        this.loopFunction = loopFunction;
        this.addWrapper(null, 0);
    }

    public LoopELWrapper(ELWrapper elWrapper, String loopFunction) {
        this.loopFunction = loopFunction;
        this.addWrapper(elWrapper, 0);
    }

    public LoopELWrapper doOpt(Object object) {
        ELWrapper elWrapper = ELBus.convertToNonLogicOpt(object);
        this.addWrapper(elWrapper, 1);
        return this;
    }

    protected void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    @Override
    public LoopELWrapper tag(String tag) {
        this.setTag(tag);
        return this;
    }

    @Override
    public LoopELWrapper id(String id) {
        this.setId(id);
        return this;
    }

    @Override
    public LoopELWrapper maxWaitSeconds(Integer maxWaitSeconds) {
        this.setMaxWaitSeconds(maxWaitSeconds);
        return this;
    }

    @Override
    protected String toEL(Integer depth, StringBuilder paramContext) {
        this.checkMaxWaitSeconds();
        Integer sonDepth = depth == null ? null : Integer.valueOf(depth + 1);
        StringBuilder sb = new StringBuilder();
        this.processWrapperTabs(sb, depth);
        sb.append(this.loopFunction).append("(");
        if (this.loopNumber != null) {
            sb.append(this.loopNumber.toString());
        } else {
            this.processWrapperNewLine(sb, depth);
            sb.append(this.getElWrapperList().get(0).toEL(sonDepth, paramContext));
            this.processWrapperNewLine(sb, depth);
            this.processWrapperTabs(sb, depth);
        }
        sb.append(")");
        if (this.parallel) {
            sb.append(".parallel(true)");
        }
        if (this.getElWrapperList().size() > 1) {
            sb.append(".DO(");
            this.processWrapperNewLine(sb, depth);
            sb.append(this.getElWrapperList().get(1).toEL(sonDepth, paramContext));
            this.processWrapperNewLine(sb, depth);
            this.processWrapperTabs(sb, depth);
            sb.append(")");
        }
        if (this.getElWrapperList().size() > 2) {
            sb.append(".BREAK(");
            this.processWrapperNewLine(sb, depth);
            sb.append(this.getElWrapperList().get(2).toEL(sonDepth, paramContext));
            this.processWrapperNewLine(sb, depth);
            this.processWrapperTabs(sb, depth);
            sb.append(")");
        }
        this.processWrapperProperty(sb, paramContext);
        return sb.toString();
    }
}

