/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.builder.el.ELWrapper;
import com.yomahub.liteflow.util.JsonUtil;
import java.util.Map;

public class NodeELWrapper
extends ELWrapper {
    private String nodeId;
    private String tag;

    public NodeELWrapper(String nodeId) {
        this.nodeId = nodeId;
        this.setNodeWrapper(this);
    }

    private void setNodeWrapper(ELWrapper elWrapper) {
        this.addWrapper(elWrapper, 0);
    }

    private NodeELWrapper getNodeWrapper() {
        return (NodeELWrapper)this.getFirstWrapper();
    }

    protected String getNodeId() {
        return this.nodeId;
    }

    protected void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public NodeELWrapper tag(String tag) {
        this.setTag(tag);
        return this;
    }

    @Override
    public NodeELWrapper id(String id) {
        this.setId(id);
        return this;
    }

    @Override
    public NodeELWrapper data(String dataName, Object object) {
        this.setData("'" + JsonUtil.toJsonString((Object)object) + "'");
        this.setDataName(dataName);
        return this;
    }

    @Override
    public NodeELWrapper data(String dataName, String jsonString) {
        this.setData(jsonString);
        this.setDataName(dataName);
        return this;
    }

    @Override
    public NodeELWrapper data(String dataName, Map<String, Object> jsonMap) {
        this.setData("'" + JsonUtil.toJsonString(jsonMap) + "'");
        this.setDataName(dataName);
        return this;
    }

    @Override
    public NodeELWrapper maxWaitSeconds(Integer maxWaitSeconds) {
        this.setMaxWaitSeconds(maxWaitSeconds);
        return this;
    }

    @Override
    protected String toEL(Integer depth, StringBuilder paramContext) {
        NodeELWrapper nodeElWrapper = this.getNodeWrapper();
        StringBuilder sb = new StringBuilder();
        this.processWrapperTabs(sb, depth);
        sb.append(StrUtil.format((CharSequence)"node(\"{}\")", (Object[])new Object[]{nodeElWrapper.getNodeId()}));
        this.processWrapperProperty(sb, paramContext);
        return sb.toString();
    }

    @Override
    protected void processWrapperProperty(StringBuilder elContext, StringBuilder paramContext) {
        if (this.getTag() != null) {
            elContext.append(StrUtil.format((CharSequence)".tag(\"{}\")", (Object[])new Object[]{this.getTag()}));
        }
        if (this.getData() != null) {
            elContext.append(StrUtil.format((CharSequence)".data({})", (Object[])new Object[]{this.getDataName()}));
            paramContext.append(StrUtil.format((CharSequence)"{} = {}", (Object[])new Object[]{this.getDataName(), this.getData()})).append(";\n");
        }
        if (this.getMaxWaitSeconds() != null) {
            elContext.append(StrUtil.format((CharSequence)".maxWaitSeconds({})", (Object[])new Object[]{String.valueOf(this.getMaxWaitSeconds())}));
        }
    }
}

