/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.builder.el.ELBus;
import com.yomahub.liteflow.builder.el.ELWrapper;
import com.yomahub.liteflow.builder.el.FinallyELWrapper;
import com.yomahub.liteflow.builder.el.PreELWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SerELWrapper
extends ELWrapper {
    private final List<PreELWrapper> preELWrapperList = new ArrayList<PreELWrapper>();
    private final List<FinallyELWrapper> finallyELWrapperList = new ArrayList<FinallyELWrapper>();

    public SerELWrapper(ELWrapper ... elWrappers) {
        this.addWrapper(elWrappers);
    }

    public SerELWrapper ser(Object ... objects) {
        ELWrapper[] elWrappers = ELBus.convertToNonBooleanOpt(objects);
        this.addWrapper(elWrappers);
        return this;
    }

    protected void addPreElWrapper(PreELWrapper preElWrapper) {
        this.preELWrapperList.add(preElWrapper);
    }

    protected void addFinallyElWrapper(FinallyELWrapper finallyElWrapper) {
        this.finallyELWrapperList.add(finallyElWrapper);
    }

    public SerELWrapper pre(Object ... objects) {
        this.addPreElWrapper(new PreELWrapper(objects));
        return this;
    }

    public SerELWrapper finallyOpt(Object ... objects) {
        this.addFinallyElWrapper(new FinallyELWrapper(objects));
        return this;
    }

    @Override
    public SerELWrapper tag(String tag) {
        this.setTag(tag);
        return this;
    }

    @Override
    public SerELWrapper id(String id) {
        this.setId(id);
        return this;
    }

    @Override
    public SerELWrapper data(String dataName, Object object) {
        super.data(dataName, object);
        return this;
    }

    @Override
    public SerELWrapper data(String dataName, String jsonString) {
        super.data(dataName, jsonString);
        return this;
    }

    @Override
    public SerELWrapper data(String dataName, Map<String, Object> jsonMap) {
        super.data(dataName, jsonMap);
        return this;
    }

    @Override
    public SerELWrapper bind(String key, String value) {
        super.bind(key, value);
        return this;
    }

    @Override
    public SerELWrapper maxWaitSeconds(Integer maxWaitSeconds) {
        this.setMaxWaitSeconds(maxWaitSeconds);
        return this;
    }

    public SerELWrapper retry(Integer count) {
        super.retry(count);
        return this;
    }

    public SerELWrapper retry(Integer count, String ... exceptions) {
        super.retry(count, exceptions);
        return this;
    }

    @Override
    protected String toEL(Integer depth, StringBuilder paramContext) {
        Integer sonDepth = depth == null ? null : Integer.valueOf(depth + 1);
        StringBuilder sb = new StringBuilder();
        this.processWrapperTabs(sb, depth);
        sb.append("SER(");
        this.processWrapperNewLine(sb, depth);
        for (PreELWrapper preElWrapper : this.preELWrapperList) {
            sb.append(StrUtil.format((CharSequence)"{},", (Object[])new Object[]{preElWrapper.toEL(sonDepth, paramContext)}));
            this.processWrapperNewLine(sb, depth);
        }
        for (int i = 0; i < this.getElWrapperList().size(); ++i) {
            if (i > 0) {
                sb.append(",");
                this.processWrapperNewLine(sb, depth);
            }
            sb.append(this.getElWrapperList().get(i).toEL(sonDepth, paramContext));
        }
        for (FinallyELWrapper finallyElWrapper : this.finallyELWrapperList) {
            sb.append(",");
            this.processWrapperNewLine(sb, depth);
            sb.append(finallyElWrapper.toEL(sonDepth, paramContext));
        }
        this.processWrapperNewLine(sb, depth);
        this.processWrapperTabs(sb, depth);
        sb.append(")");
        this.processWrapperProperty(sb, paramContext);
        return sb.toString();
    }
}

