/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.builder.el.ELBus;
import com.yomahub.liteflow.builder.el.ELWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class WhenELWrapper
extends ELWrapper {
    private boolean any;
    private boolean ignoreError;
    private String customThreadExecutor;
    private final List<String> mustExecuteList;

    public WhenELWrapper(ELWrapper ... elWrappers) {
        this.addWrapper(elWrappers);
        this.mustExecuteList = new ArrayList<String>();
    }

    public WhenELWrapper when(Object ... objects) {
        ELWrapper[] elWrappers = ELBus.convertToNonBooleanOpt(objects);
        this.addWrapper(elWrappers);
        return this;
    }

    public WhenELWrapper any(boolean any) {
        this.any = any;
        return this;
    }

    public WhenELWrapper ignoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
        return this;
    }

    public WhenELWrapper customThreadExecutor(String customThreadExecutor) {
        this.customThreadExecutor = customThreadExecutor;
        return this;
    }

    public WhenELWrapper must(String ... mustExecuteWrappers) {
        this.mustExecuteList.addAll(Arrays.asList(mustExecuteWrappers));
        return this;
    }

    @Override
    public WhenELWrapper tag(String tag) {
        this.setTag(tag);
        return this;
    }

    @Override
    public WhenELWrapper id(String id) {
        this.setId(id);
        return this;
    }

    @Override
    public WhenELWrapper data(String dataName, Object object) {
        super.data(dataName, object);
        return this;
    }

    @Override
    public WhenELWrapper data(String dataName, String jsonString) {
        super.data(dataName, jsonString);
        return this;
    }

    @Override
    public WhenELWrapper data(String dataName, Map<String, Object> jsonMap) {
        super.data(dataName, jsonMap);
        return this;
    }

    @Override
    public WhenELWrapper bind(String key, String value) {
        super.bind(key, value);
        return this;
    }

    @Override
    public WhenELWrapper maxWaitSeconds(Integer maxWaitSeconds) {
        this.setMaxWaitSeconds(maxWaitSeconds);
        return this;
    }

    public WhenELWrapper retry(Integer count) {
        super.retry(count);
        return this;
    }

    public WhenELWrapper retry(Integer count, String ... exceptions) {
        super.retry(count, exceptions);
        return this;
    }

    @Override
    protected String toEL(Integer depth, StringBuilder paramContext) {
        int i;
        Integer sonDepth = depth == null ? null : Integer.valueOf(depth + 1);
        StringBuilder sb = new StringBuilder();
        this.processWrapperTabs(sb, depth);
        sb.append("WHEN(");
        this.processWrapperNewLine(sb, depth);
        for (i = 0; i < this.getElWrapperList().size(); ++i) {
            if (i > 0) {
                sb.append(",");
                this.processWrapperNewLine(sb, depth);
            }
            sb.append(this.getElWrapperList().get(i).toEL(sonDepth, paramContext));
        }
        this.processWrapperNewLine(sb, depth);
        this.processWrapperTabs(sb, depth);
        sb.append(")");
        if (this.any) {
            sb.append(".any(true)");
        }
        if (this.ignoreError) {
            sb.append(".ignoreError(true)");
        }
        if (StrUtil.isNotBlank((CharSequence)this.customThreadExecutor)) {
            sb.append(StrUtil.format((CharSequence)".threadPool(\"{}\")", (Object[])new Object[]{this.customThreadExecutor}));
        }
        if (CollectionUtil.isNotEmpty(this.mustExecuteList)) {
            if (this.any) {
                throw new IllegalArgumentException("'.must()' and '.any()' can use in when component at the same time!");
            }
            sb.append(".must(");
            for (i = 0; i < this.mustExecuteList.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(StrUtil.format((CharSequence)"\"{}\"", (Object[])new Object[]{this.mustExecuteList.get(i)}));
            }
            sb.append(")");
        }
        this.processWrapperProperty(sb, paramContext);
        return sb.toString();
    }
}

