/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.apollo.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.yomahub.liteflow.builder.LiteFlowNodeBuilder;
import com.yomahub.liteflow.builder.el.LiteFlowChainELBuilder;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.apollo.exception.ApolloException;
import com.yomahub.liteflow.parser.apollo.vo.ApolloParserConfigVO;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloParseHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ApolloParseHelper.class);
    private final String CHAIN_XML_PATTERN = "<chain name=\"{}\">{}</chain>";
    private final String NODE_XML_PATTERN = "<nodes>{}</nodes>";
    private final String NODE_ITEM_XML_PATTERN = "<node id=\"{}\" name=\"{}\" type=\"{}\"><![CDATA[{}]]></node>";
    private final String XML_PATTERN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>";
    private final ApolloParserConfigVO apolloParserConfigVO;
    private Config chainConfig;
    private Config scriptConfig;

    public ApolloParseHelper(ApolloParserConfigVO apolloParserConfigVO) {
        this.apolloParserConfigVO = apolloParserConfigVO;
        try {
            try {
                this.chainConfig = (Config)ContextAwareHolder.loadContextAware().getBean("chainConfig");
                this.scriptConfig = (Config)ContextAwareHolder.loadContextAware().getBean("scriptConfig");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ObjectUtil.isNull((Object)this.chainConfig)) {
                this.chainConfig = ConfigService.getConfig((String)apolloParserConfigVO.getChainNamespace());
                String scriptNamespace = apolloParserConfigVO.getScriptNamespace();
                if (StrUtil.isNotBlank((CharSequence)scriptNamespace)) {
                    this.scriptConfig = ConfigService.getConfig((String)scriptNamespace);
                }
            }
        }
        catch (Exception e) {
            throw new ApolloException(e.getMessage());
        }
    }

    public String getContent() {
        try {
            Set scriptNamespaces;
            Set propertyNames = this.chainConfig.getPropertyNames();
            List chainItemContentList = propertyNames.stream().map(item -> StrUtil.format((CharSequence)"<chain name=\"{}\">{}</chain>", (Object[])new Object[]{item, this.chainConfig.getProperty(item, "")})).collect(Collectors.toList());
            String chainAllContent = CollUtil.join(chainItemContentList, (CharSequence)"");
            String scriptAllContent = "";
            if (Objects.nonNull(this.scriptConfig) && CollectionUtil.isNotEmpty((Collection)(scriptNamespaces = this.scriptConfig.getPropertyNames()))) {
                List scriptItemContentList = scriptNamespaces.stream().map(item -> this.convert((String)item, this.scriptConfig.getProperty(item, ""))).filter(Objects::nonNull).map(item -> StrUtil.format((CharSequence)"<node id=\"{}\" name=\"{}\" type=\"{}\"><![CDATA[{}]]></node>", (Object[])new Object[]{item.getNodeId(), item.getName(), item.getType(), item.getScript()})).collect(Collectors.toList());
                scriptAllContent = StrUtil.format((CharSequence)"<nodes>{}</nodes>", (Object[])new Object[]{CollUtil.join(scriptItemContentList, (CharSequence)"")});
            }
            return StrUtil.format((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>", (Object[])new Object[]{scriptAllContent, chainAllContent});
        }
        catch (Exception e) {
            throw new ApolloException(e.getMessage());
        }
    }

    public void listenApollo() {
        this.chainConfig.addChangeListener(changeEvent -> changeEvent.changedKeys().forEach(changeKey -> {
            ConfigChange configChange = changeEvent.getChange(changeKey);
            String newValue = configChange.getNewValue();
            PropertyChangeType changeType = configChange.getChangeType();
            switch (changeType) {
                case ADDED: 
                case MODIFIED: {
                    LOG.info("starting reload flow config... {} key={} value={},", new Object[]{changeType.name(), changeKey, newValue});
                    LiteFlowChainELBuilder.createChain().setChainId(changeKey).setEL(newValue).build();
                    break;
                }
                case DELETED: {
                    LOG.info("starting reload flow config... delete key={}", changeKey);
                    FlowBus.removeChain((String)changeKey);
                    break;
                }
            }
        }));
        if (StrUtil.isNotBlank((CharSequence)this.apolloParserConfigVO.getScriptNamespace())) {
            this.scriptConfig.addChangeListener(changeEvent -> changeEvent.changedKeys().forEach(changeKey -> {
                NodeSimpleVO nodeSimpleVO;
                ConfigChange configChange = changeEvent.getChange(changeKey);
                String newValue = configChange.getNewValue();
                PropertyChangeType changeType = configChange.getChangeType();
                if (PropertyChangeType.DELETED.equals((Object)changeType)) {
                    newValue = null;
                }
                if (Objects.isNull(nodeSimpleVO = this.convert((String)changeKey, newValue))) {
                    LOG.error("key={} is not a valid node config, ignore it", changeKey);
                    return;
                }
                switch (changeType) {
                    case ADDED: 
                    case MODIFIED: {
                        LOG.info("starting reload flow config... {} key={} value={},", new Object[]{changeType.name(), changeKey, newValue});
                        LiteFlowNodeBuilder.createScriptNode().setId(nodeSimpleVO.getNodeId()).setType(NodeTypeEnum.getEnumByCode((String)nodeSimpleVO.getType())).setName(nodeSimpleVO.getName()).setScript(nodeSimpleVO.getScript()).build();
                        break;
                    }
                    case DELETED: {
                        LOG.info("starting reload flow config... delete key={}", changeKey);
                        FlowBus.getNodeMap().remove(nodeSimpleVO.getNodeId());
                        break;
                    }
                }
            }));
        }
    }

    private NodeSimpleVO convert(String key, String value) {
        List matchItemList = ReUtil.findAllGroup0((String)"(?<=[^:]:)[^:]+|[^:]+(?=:[^:])", (CharSequence)key);
        if (CollUtil.isEmpty((Collection)matchItemList)) {
            return null;
        }
        NodeSimpleVO nodeSimpleVO = new NodeSimpleVO();
        if (matchItemList.size() > 1) {
            nodeSimpleVO.setNodeId((String)matchItemList.get(0));
            nodeSimpleVO.setType((String)matchItemList.get(1));
        }
        if (matchItemList.size() > 2) {
            nodeSimpleVO.setName((String)matchItemList.get(2));
        }
        nodeSimpleVO.setScript(value);
        return nodeSimpleVO;
    }

    private static class NodeSimpleVO {
        private String nodeId;
        private String type;
        private String name = "";
        private String script;

        private NodeSimpleVO() {
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getScript() {
            return this.script;
        }

        public void setScript(String script) {
            this.script = script;
        }
    }
}

