/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.apollo;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.FlowInitHook;
import com.yomahub.liteflow.parser.apollo.exception.ApolloException;
import com.yomahub.liteflow.parser.apollo.util.ApolloParseHelper;
import com.yomahub.liteflow.parser.apollo.vo.ApolloParserConfigVO;
import com.yomahub.liteflow.parser.el.ClassXmlFlowELParser;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.util.JsonUtil;
import java.util.Map;
import java.util.Objects;

public class ApolloXmlELParser
extends ClassXmlFlowELParser {
    private final ApolloParseHelper apolloParseHelper;

    public ApolloXmlELParser() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        try {
            ApolloParserConfigVO apolloParserConfigVO = null;
            if (MapUtil.isNotEmpty((Map)liteflowConfig.getRuleSourceExtDataMap())) {
                apolloParserConfigVO = (ApolloParserConfigVO)BeanUtil.toBean((Object)liteflowConfig.getRuleSourceExtDataMap(), ApolloParserConfigVO.class, (CopyOptions)CopyOptions.create());
            } else if (StrUtil.isNotBlank((CharSequence)liteflowConfig.getRuleSourceExtData())) {
                apolloParserConfigVO = (ApolloParserConfigVO)JsonUtil.parseObject((String)liteflowConfig.getRuleSourceExtData(), ApolloParserConfigVO.class);
            }
            if (Objects.isNull(apolloParserConfigVO)) {
                throw new ApolloException("ruleSourceExtData or map is empty");
            }
            if (StrUtil.isBlank((CharSequence)apolloParserConfigVO.getChainNamespace())) {
                throw new ApolloException("chainNamespace is empty, you must configure the chainNamespace property");
            }
            this.apolloParseHelper = new ApolloParseHelper(apolloParserConfigVO);
        }
        catch (Exception e) {
            throw new ApolloException(e);
        }
    }

    public String parseCustom() {
        try {
            String content = this.apolloParseHelper.getContent();
            FlowInitHook.addHook(() -> {
                this.apolloParseHelper.listenApollo();
                return true;
            });
            return content;
        }
        catch (Exception e) {
            throw new ApolloException(e);
        }
    }
}

