/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.apollo.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.yomahub.liteflow.builder.LiteFlowNodeBuilder;
import com.yomahub.liteflow.builder.el.LiteFlowChainELBuilder;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.apollo.exception.ApolloException;
import com.yomahub.liteflow.parser.apollo.vo.ApolloParserConfigVO;
import com.yomahub.liteflow.parser.helper.NodeConvertHelper;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import com.yomahub.liteflow.util.RuleParsePluginUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloParseHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ApolloParseHelper.class);
    private final String NODE_XML_PATTERN = "<nodes>{}</nodes>";
    private final String XML_PATTERN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>";
    private final ApolloParserConfigVO apolloParserConfigVO;
    private Config chainConfig;
    private Config scriptConfig;

    public ApolloParseHelper(ApolloParserConfigVO apolloParserConfigVO) {
        this.apolloParserConfigVO = apolloParserConfigVO;
        try {
            try {
                this.chainConfig = (Config)ContextAwareHolder.loadContextAware().getBean("chainConfig");
                this.scriptConfig = (Config)ContextAwareHolder.loadContextAware().getBean("scriptConfig");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ObjectUtil.isNull((Object)this.chainConfig)) {
                this.chainConfig = ConfigService.getConfig((String)apolloParserConfigVO.getChainNamespace());
                String scriptNamespace = apolloParserConfigVO.getScriptNamespace();
                if (StrUtil.isNotBlank((CharSequence)scriptNamespace)) {
                    this.scriptConfig = ConfigService.getConfig((String)scriptNamespace);
                }
            }
        }
        catch (Exception e) {
            throw new ApolloException(e.getMessage());
        }
    }

    public String getContent() {
        try {
            Set scriptNamespaces;
            Set propertyNames = this.chainConfig.getPropertyNames();
            List chainItemContentList = propertyNames.stream().map(item -> RuleParsePluginUtil.parseChainKey((String)item).toElXml(this.chainConfig.getProperty(item, ""))).collect(Collectors.toList());
            String chainAllContent = CollUtil.join(chainItemContentList, (CharSequence)"");
            String scriptAllContent = "";
            if (Objects.nonNull(this.scriptConfig) && CollectionUtil.isNotEmpty((Collection)(scriptNamespaces = this.scriptConfig.getPropertyNames()))) {
                List scriptItemContentList = scriptNamespaces.stream().map(item -> this.convert((String)item, this.scriptConfig.getProperty(item, ""))).map(RuleParsePluginUtil::toScriptXml).collect(Collectors.toList());
                scriptAllContent = StrUtil.format((CharSequence)"<nodes>{}</nodes>", (Object[])new Object[]{CollUtil.join(scriptItemContentList, (CharSequence)"")});
            }
            return StrUtil.format((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>", (Object[])new Object[]{scriptAllContent, chainAllContent});
        }
        catch (Exception e) {
            throw new ApolloException(e.getMessage());
        }
    }

    public void listenApollo() {
        this.chainConfig.addChangeListener(changeEvent -> changeEvent.changedKeys().forEach(changeKey -> {
            ConfigChange configChange = changeEvent.getChange(changeKey);
            String newValue = configChange.getNewValue();
            PropertyChangeType changeType = configChange.getChangeType();
            Pair pair = RuleParsePluginUtil.parseIdKey((String)changeKey);
            String chainId = (String)pair.getValue();
            switch (changeType) {
                case ADDED: 
                case MODIFIED: {
                    LOG.info("starting reload flow config... {} key={} value={},", new Object[]{changeType.name(), changeKey, newValue});
                    if (((Boolean)pair.getKey()).booleanValue()) {
                        LiteFlowChainELBuilder.createChain().setChainId(chainId).setEL(newValue).build();
                        break;
                    }
                    FlowBus.removeChain((String)chainId);
                    break;
                }
                case DELETED: {
                    LOG.info("starting reload flow config... delete key={}", changeKey);
                    FlowBus.removeChain((String)chainId);
                    break;
                }
            }
        }));
        if (StrUtil.isNotBlank((CharSequence)this.apolloParserConfigVO.getScriptNamespace())) {
            this.scriptConfig.addChangeListener(changeEvent -> changeEvent.changedKeys().forEach(changeKey -> {
                ConfigChange configChange = changeEvent.getChange(changeKey);
                String newValue = configChange.getNewValue();
                PropertyChangeType changeType = configChange.getChangeType();
                if (PropertyChangeType.DELETED.equals((Object)changeType)) {
                    newValue = null;
                }
                NodeConvertHelper.NodeSimpleVO nodeSimpleVO = this.convert((String)changeKey, newValue);
                switch (changeType) {
                    case ADDED: 
                    case MODIFIED: {
                        LOG.info("starting reload flow config... {} key={} value={},", new Object[]{changeType.name(), changeKey, newValue});
                        if (nodeSimpleVO.getEnable().booleanValue()) {
                            LiteFlowNodeBuilder.createScriptNode().setId(nodeSimpleVO.getNodeId()).setType(NodeTypeEnum.getEnumByCode((String)nodeSimpleVO.getType())).setName(nodeSimpleVO.getName()).setScript(newValue).setLanguage(nodeSimpleVO.getLanguage()).build();
                            break;
                        }
                        FlowBus.unloadScriptNode((String)nodeSimpleVO.getNodeId());
                        break;
                    }
                    case DELETED: {
                        LOG.info("starting reload flow config... delete key={}", changeKey);
                        FlowBus.unloadScriptNode((String)nodeSimpleVO.getNodeId());
                        break;
                    }
                }
            }));
        }
    }

    private NodeConvertHelper.NodeSimpleVO convert(String key, String value) {
        NodeConvertHelper.NodeSimpleVO nodeSimpleVO = NodeConvertHelper.convert((String)key);
        nodeSimpleVO.setScript(value);
        return nodeSimpleVO;
    }
}

