/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.etcd;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.FlowInitHook;
import com.yomahub.liteflow.parser.el.ClassXmlFlowELParser;
import com.yomahub.liteflow.parser.etcd.exception.EtcdException;
import com.yomahub.liteflow.parser.etcd.util.EtcdParserHelper;
import com.yomahub.liteflow.parser.etcd.vo.EtcdParserVO;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.util.JsonUtil;
import java.util.Map;
import java.util.Objects;

public class EtcdXmlELParser
extends ClassXmlFlowELParser {
    private final EtcdParserHelper etcdParserHelper;

    public EtcdXmlELParser() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        try {
            EtcdParserVO etcdParserVO = null;
            if (MapUtil.isNotEmpty((Map)liteflowConfig.getRuleSourceExtDataMap())) {
                etcdParserVO = (EtcdParserVO)BeanUtil.toBean((Object)liteflowConfig.getRuleSourceExtDataMap(), EtcdParserVO.class, (CopyOptions)CopyOptions.create());
            } else if (StrUtil.isNotBlank((CharSequence)liteflowConfig.getRuleSourceExtData())) {
                etcdParserVO = (EtcdParserVO)JsonUtil.parseObject((String)liteflowConfig.getRuleSourceExtData(), EtcdParserVO.class);
            }
            if (Objects.isNull(etcdParserVO)) {
                throw new EtcdException("rule-source-ext-data is empty");
            }
            if (StrUtil.isBlank((CharSequence)etcdParserVO.getChainPath())) {
                throw new EtcdException("You must configure the chainPath property");
            }
            if (StrUtil.isBlank((CharSequence)etcdParserVO.getEndpoints())) {
                throw new EtcdException("etcd endpoints is empty");
            }
            this.etcdParserHelper = new EtcdParserHelper(etcdParserVO);
        }
        catch (Exception e) {
            throw new EtcdException(e);
        }
    }

    public String parseCustom() {
        try {
            String content = this.etcdParserHelper.getContent();
            FlowInitHook.addHook(() -> {
                this.etcdParserHelper.listen();
                return true;
            });
            return content;
        }
        catch (Exception e) {
            throw new EtcdException(e);
        }
    }
}

