/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.etcd.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.builder.LiteFlowNodeBuilder;
import com.yomahub.liteflow.builder.el.LiteFlowChainELBuilder;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.etcd.EtcdClient;
import com.yomahub.liteflow.parser.etcd.exception.EtcdException;
import com.yomahub.liteflow.parser.etcd.vo.EtcdParserVO;
import com.yomahub.liteflow.parser.helper.NodeConvertHelper;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import com.yomahub.liteflow.util.RuleParsePluginUtil;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientBuilder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdParserHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EtcdParserHelper.class);
    private final String NODE_XML_PATTERN = "<nodes>{}</nodes>";
    private final String XML_PATTERN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>";
    private static final String SEPARATOR = "/";
    private final EtcdParserVO etcdParserVO;
    private EtcdClient client;

    public EtcdParserHelper(EtcdParserVO etcdParserVO) {
        this.etcdParserVO = etcdParserVO;
        try {
            try {
                this.client = (EtcdClient)ContextAwareHolder.loadContextAware().getBean(EtcdClient.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.client == null) {
                ClientBuilder clientBuilder = Client.builder().endpoints(etcdParserVO.getEndpoints().split(","));
                if (StrUtil.isNotBlank((CharSequence)etcdParserVO.getNamespace())) {
                    clientBuilder.namespace(ByteSequence.from((String)etcdParserVO.getNamespace(), (Charset)CharsetUtil.CHARSET_UTF_8));
                }
                if (StrUtil.isAllNotBlank((CharSequence[])new CharSequence[]{etcdParserVO.getUser(), etcdParserVO.getPassword()})) {
                    clientBuilder.user(ByteSequence.from((String)etcdParserVO.getUser(), (Charset)CharsetUtil.CHARSET_UTF_8));
                    clientBuilder.password(ByteSequence.from((String)etcdParserVO.getPassword(), (Charset)CharsetUtil.CHARSET_UTF_8));
                }
                this.client = new EtcdClient(clientBuilder.build());
            }
        }
        catch (Exception e) {
            throw new EtcdException(e);
        }
    }

    public String getContent() {
        try {
            List<String> chainNameList = this.client.getChildrenKeys(this.etcdParserVO.getChainPath(), SEPARATOR);
            ArrayList<String> chainItemContentList = new ArrayList<String>();
            for (String chainName : chainNameList) {
                RuleParsePluginUtil.ChainDto chainDto = RuleParsePluginUtil.parseChainKey((String)chainName);
                String chainData = this.client.get(StrUtil.format((CharSequence)"{}/{}", (Object[])new Object[]{this.etcdParserVO.getChainPath(), chainName}));
                if (!StrUtil.isNotBlank((CharSequence)chainData)) continue;
                chainItemContentList.add(chainDto.toElXml(chainData));
            }
            String chainAllContent = CollUtil.join(chainItemContentList, (CharSequence)"");
            String scriptAllContent = "";
            if (this.hasScript()) {
                List scriptNodeValueList = this.client.getChildrenKeys(this.etcdParserVO.getScriptPath(), SEPARATOR).stream().filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
                ArrayList<String> scriptItemContentList = new ArrayList<String>();
                for (String scriptNodeValue : scriptNodeValueList) {
                    NodeConvertHelper.NodeSimpleVO nodeSimpleVO = NodeConvertHelper.convert((String)scriptNodeValue);
                    if (Objects.isNull(nodeSimpleVO)) {
                        throw new EtcdException(StrUtil.format((CharSequence)"The name of the etcd node is invalid:{}", (Object[])new Object[]{scriptNodeValue}));
                    }
                    String scriptData = this.client.get(StrUtil.format((CharSequence)"{}/{}", (Object[])new Object[]{this.etcdParserVO.getScriptPath(), scriptNodeValue}));
                    nodeSimpleVO.setScript(scriptData);
                    scriptItemContentList.add(RuleParsePluginUtil.toScriptXml((NodeConvertHelper.NodeSimpleVO)nodeSimpleVO));
                }
                scriptAllContent = StrUtil.format((CharSequence)"<nodes>{}</nodes>", (Object[])new Object[]{CollUtil.join(scriptItemContentList, (CharSequence)"")});
            }
            return StrUtil.format((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>", (Object[])new Object[]{scriptAllContent, chainAllContent});
        }
        catch (Exception e) {
            throw new EtcdException(e);
        }
    }

    public boolean hasScript() {
        if (StrUtil.isBlank((CharSequence)this.etcdParserVO.getScriptPath())) {
            return false;
        }
        try {
            List<String> chainNameList = this.client.getChildrenKeys(this.etcdParserVO.getScriptPath(), SEPARATOR);
            return !CollUtil.isEmpty(chainNameList);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void listen() {
        this.client.watchChildChange(this.etcdParserVO.getChainPath(), (updatePath, updateValue) -> {
            LOG.info("starting reload flow config... update path={} value={},", updatePath, updateValue);
            String changeKey = FileNameUtil.getName((String)updatePath);
            Pair pair = RuleParsePluginUtil.parseIdKey((String)changeKey);
            String chainId = (String)pair.getValue();
            if (((Boolean)pair.getKey()).booleanValue()) {
                LiteFlowChainELBuilder.createChain().setChainId(chainId).setEL(updateValue).build();
            } else {
                FlowBus.removeChain((String)chainId);
            }
        }, deletePath -> {
            LOG.info("starting reload flow config... delete path={}", deletePath);
            String chainKey = FileNameUtil.getName((String)deletePath);
            Pair pair = RuleParsePluginUtil.parseIdKey((String)chainKey);
            FlowBus.removeChain((String)((String)pair.getValue()));
        });
        if (StrUtil.isNotBlank((CharSequence)this.etcdParserVO.getScriptPath())) {
            this.client.watchChildChange(this.etcdParserVO.getScriptPath(), (updatePath, updateValue) -> {
                LOG.info("starting reload flow config... update path={} value={}", updatePath, updateValue);
                String scriptNodeValue = FileNameUtil.getName((String)updatePath);
                NodeConvertHelper.NodeSimpleVO nodeSimpleVO = NodeConvertHelper.convert((String)scriptNodeValue);
                if (nodeSimpleVO.getEnable().booleanValue()) {
                    LiteFlowNodeBuilder.createScriptNode().setId(nodeSimpleVO.getNodeId()).setType(NodeTypeEnum.getEnumByCode((String)nodeSimpleVO.getType())).setName(nodeSimpleVO.getName()).setScript(updateValue).setLanguage(nodeSimpleVO.getLanguage()).build();
                } else {
                    FlowBus.unloadScriptNode((String)nodeSimpleVO.getNodeId());
                }
            }, deletePath -> {
                LOG.info("starting reload flow config... delete path={}", deletePath);
                String scriptNodeValue = FileNameUtil.getName((String)deletePath);
                NodeConvertHelper.NodeSimpleVO nodeSimpleVO = NodeConvertHelper.convert((String)scriptNodeValue);
                FlowBus.unloadScriptNode((String)nodeSimpleVO.getNodeId());
            });
        }
    }
}

