/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.redis;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.FlowInitHook;
import com.yomahub.liteflow.parser.el.ClassXmlFlowELParser;
import com.yomahub.liteflow.parser.redis.exception.RedisException;
import com.yomahub.liteflow.parser.redis.mode.RedisMode;
import com.yomahub.liteflow.parser.redis.mode.RedisParserHelper;
import com.yomahub.liteflow.parser.redis.mode.RedisParserMode;
import com.yomahub.liteflow.parser.redis.mode.polling.RedisParserPollingMode;
import com.yomahub.liteflow.parser.redis.mode.subscribe.RedisParserSubscribeMode;
import com.yomahub.liteflow.parser.redis.vo.RedisParserVO;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.util.JsonUtil;
import java.util.Map;
import java.util.Objects;

public class RedisXmlELParser
extends ClassXmlFlowELParser {
    private final RedisParserHelper redisParserHelper;
    private static final String ERROR_COMMON_MSG = "ruleSourceExtData or map is empty";
    private static final String ERROR_MSG_PATTERN = "ruleSourceExtData {} is blank";

    public RedisXmlELParser() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        try {
            String configJson;
            RedisParserVO redisParserVO = null;
            if (MapUtil.isNotEmpty((Map)liteflowConfig.getRuleSourceExtDataMap())) {
                configJson = JsonUtil.toJsonString((Object)liteflowConfig.getRuleSourceExtDataMap());
            } else if (StrUtil.isNotBlank((CharSequence)liteflowConfig.getRuleSourceExtData())) {
                configJson = liteflowConfig.getRuleSourceExtData();
            } else {
                throw new RedisException(ERROR_COMMON_MSG);
            }
            redisParserVO = (RedisParserVO)JsonUtil.parseObject((String)configJson, RedisParserVO.class);
            if (Objects.isNull(redisParserVO)) {
                throw new RedisException(ERROR_COMMON_MSG);
            }
            this.checkParserVO(redisParserVO);
            RedisParserMode mode = redisParserVO.getMode();
            switch (mode) {
                case SUB: 
                case SUBSCRIBE: {
                    this.redisParserHelper = new RedisParserSubscribeMode(redisParserVO);
                    break;
                }
                default: {
                    this.redisParserHelper = new RedisParserPollingMode(redisParserVO);
                    break;
                }
            }
        }
        catch (RedisException redisException) {
            throw redisException;
        }
        catch (Exception e) {
            throw new RedisException(e.getMessage());
        }
    }

    public String parseCustom() {
        try {
            String content = this.redisParserHelper.getContent();
            FlowInitHook.addHook(() -> {
                this.redisParserHelper.listenRedis();
                return true;
            });
            return content;
        }
        catch (Exception e) {
            throw new RedisException(e.getMessage());
        }
    }

    private void checkParserVO(RedisParserVO redisParserVO) {
        if (redisParserVO.getRedisMode().equals((Object)RedisMode.SINGLE) && StrUtil.isBlank((CharSequence)redisParserVO.getHost())) {
            throw new RedisException(StrFormatter.format((String)ERROR_MSG_PATTERN, (Object[])new Object[]{"host"}));
        }
        if (redisParserVO.getRedisMode().equals((Object)RedisMode.SINGLE) && ObjectUtil.isNull((Object)redisParserVO.getPort())) {
            throw new RedisException(StrFormatter.format((String)ERROR_MSG_PATTERN, (Object[])new Object[]{"port"}));
        }
        if (redisParserVO.getRedisMode().equals((Object)RedisMode.SENTINEL) && StrUtil.isBlank((CharSequence)redisParserVO.getMasterName())) {
            throw new RedisException(StrFormatter.format((String)ERROR_MSG_PATTERN, (Object[])new Object[]{"master name"}));
        }
        if (redisParserVO.getRedisMode().equals((Object)RedisMode.SENTINEL) && CollectionUtil.isEmpty(redisParserVO.getSentinelAddress())) {
            throw new RedisException(StrFormatter.format((String)ERROR_MSG_PATTERN, (Object[])new Object[]{"sentinel address list"}));
        }
        if (ObjectUtil.isNull((Object)redisParserVO.getChainDataBase())) {
            throw new RedisException(StrFormatter.format((String)ERROR_MSG_PATTERN, (Object[])new Object[]{"chainDataBase"}));
        }
        if (StrUtil.isBlank((CharSequence)redisParserVO.getChainKey())) {
            throw new RedisException(StrFormatter.format((String)ERROR_MSG_PATTERN, (Object[])new Object[]{"chainKey"}));
        }
    }
}

