/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.redis.mode;

import cn.hutool.core.lang.Pair;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.builder.LiteFlowNodeBuilder;
import com.yomahub.liteflow.builder.el.LiteFlowChainELBuilder;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.parser.helper.NodeConvertHelper;
import com.yomahub.liteflow.parser.redis.vo.RedisParserVO;
import com.yomahub.liteflow.util.RuleParsePluginUtil;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;

public interface RedisParserHelper {
    public static final LFLog LOG = LFLoggerManager.getLogger(RedisParserHelper.class);
    public static final String SINGLE_REDIS_URL_PATTERN = "redis://{}:{}";
    public static final String SENTINEL_REDIS_URL_PATTERN = "redis://{}";
    public static final String CHAIN_XML_PATTERN = "<chain name=\"{}\">{}</chain>";
    public static final String NODE_XML_PATTERN = "<nodes>{}</nodes>";
    public static final String NODE_ITEM_XML_PATTERN = "<node id=\"{}\" name=\"{}\" type=\"{}\"><![CDATA[{}]]></node>";
    public static final String NODE_ITEM_WITH_LANGUAGE_XML_PATTERN = "<node id=\"{}\" name=\"{}\" type=\"{}\" language=\"{}\"><![CDATA[{}]]></node>";
    public static final String XML_PATTERN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>";

    public String getContent();

    public void listenRedis();

    default public Config getSingleRedissonConfig(RedisParserVO redisParserVO, Integer dataBase) {
        Config config = new Config();
        String redisAddress = StrFormatter.format((String)SINGLE_REDIS_URL_PATTERN, (Object[])new Object[]{redisParserVO.getHost(), redisParserVO.getPort()});
        if (StrUtil.isNotBlank((CharSequence)redisParserVO.getUsername()) && StrUtil.isNotBlank((CharSequence)redisParserVO.getPassword())) {
            ((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(redisAddress).setUsername(redisParserVO.getUsername())).setPassword(redisParserVO.getPassword())).setDatabase(dataBase.intValue());
        } else if (StrUtil.isNotBlank((CharSequence)redisParserVO.getPassword())) {
            ((SingleServerConfig)config.useSingleServer().setAddress(redisAddress).setPassword(redisParserVO.getPassword())).setDatabase(dataBase.intValue());
        } else {
            config.useSingleServer().setAddress(redisAddress).setDatabase(dataBase.intValue());
        }
        return config;
    }

    default public Config getSentinelRedissonConfig(RedisParserVO redisParserVO, Integer dataBase) {
        Config config = new Config();
        SentinelServersConfig sentinelConfig = config.useSentinelServers().setMasterName(redisParserVO.getMasterName());
        redisParserVO.getSentinelAddress().forEach(address -> sentinelConfig.addSentinelAddress(new String[]{StrFormatter.format((String)SENTINEL_REDIS_URL_PATTERN, (Object[])new Object[]{address})}));
        if (StrUtil.isNotBlank((CharSequence)redisParserVO.getUsername()) && StrUtil.isNotBlank((CharSequence)redisParserVO.getPassword())) {
            ((SentinelServersConfig)((SentinelServersConfig)sentinelConfig.setUsername(redisParserVO.getUsername())).setPassword(redisParserVO.getPassword())).setDatabase(dataBase.intValue());
        } else if (StrUtil.isNotBlank((CharSequence)redisParserVO.getPassword())) {
            ((SentinelServersConfig)sentinelConfig.setPassword(redisParserVO.getPassword())).setDatabase(dataBase.intValue());
        } else {
            sentinelConfig.setDatabase(dataBase.intValue());
        }
        return config;
    }

    public static boolean changeScriptNode(String scriptKeyValue, String newValue) {
        NodeConvertHelper.NodeSimpleVO nodeSimpleVO = NodeConvertHelper.convert((String)scriptKeyValue);
        if (BooleanUtil.isTrue((Boolean)nodeSimpleVO.getEnable())) {
            if (StrUtil.isNotBlank((CharSequence)nodeSimpleVO.getLanguage())) {
                LiteFlowNodeBuilder.createScriptNode().setId(nodeSimpleVO.getNodeId()).setType(NodeTypeEnum.getEnumByCode((String)nodeSimpleVO.getType())).setName(nodeSimpleVO.getName()).setScript(newValue).setLanguage(nodeSimpleVO.getLanguage()).build();
            } else {
                LiteFlowNodeBuilder.createScriptNode().setId(nodeSimpleVO.getNodeId()).setType(NodeTypeEnum.getEnumByCode((String)nodeSimpleVO.getType())).setName(nodeSimpleVO.getName()).setScript(newValue).build();
            }
            return true;
        }
        FlowBus.unloadScriptNode((String)nodeSimpleVO.getNodeId());
        return false;
    }

    public static void changeChain(String chainId, String value) {
        Pair pair = RuleParsePluginUtil.parseIdKey((String)chainId);
        if (BooleanUtil.isTrue((Boolean)((Boolean)pair.getKey()))) {
            LiteFlowChainELBuilder.createChain().setChainId(chainId).setEL(value).build();
        } else {
            FlowBus.removeChain((String)chainId);
        }
    }
}

