/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.redis.mode.polling;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.thread.NamedThreadFactory;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestUtil;
import com.yomahub.liteflow.parser.helper.NodeConvertHelper;
import com.yomahub.liteflow.parser.redis.exception.RedisException;
import com.yomahub.liteflow.parser.redis.mode.RClient;
import com.yomahub.liteflow.parser.redis.mode.RedisMode;
import com.yomahub.liteflow.parser.redis.mode.RedisParserHelper;
import com.yomahub.liteflow.parser.redis.mode.polling.ChainPollingTask;
import com.yomahub.liteflow.parser.redis.mode.polling.ScriptPollingTask;
import com.yomahub.liteflow.parser.redis.vo.RedisParserVO;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import com.yomahub.liteflow.util.RuleParsePluginUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.redisson.Redisson;
import org.redisson.config.Config;

public class RedisParserPollingMode
implements RedisParserHelper {
    private final RedisParserVO redisParserVO;
    private RClient chainClient;
    private RClient scriptClient;
    private Integer chainNum = 0;
    private Integer scriptNum = 0;
    private Map<String, String> chainSHAMap = new HashMap<String, String>();
    private Map<String, String> scriptSHAMap = new HashMap<String, String>();
    private static final int CORE_POOL_SIZE = 2;
    private static ScheduledThreadPoolExecutor pollExecutor;
    private final String luaOfKey = "local keys = redis.call(\"hkeys\", KEYS[1]);\nreturn #keys;\n";
    private final String luaOfValue = "local key = KEYS[1];\nlocal field = KEYS[2];\nlocal value, err = redis.call(\"hget\", key, field);\nif value == false or value == nil then\n    return \"nil\";\nend\nlocal sha1 = redis.sha1hex(value);\nreturn sha1;";

    public RedisParserPollingMode(RedisParserVO redisParserVO) {
        this.redisParserVO = redisParserVO;
        try {
            try {
                this.chainClient = (RClient)ContextAwareHolder.loadContextAware().getBean("chainClient");
                this.scriptClient = (RClient)ContextAwareHolder.loadContextAware().getBean("scriptClient");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ObjectUtil.isNull((Object)this.chainClient)) {
                RedisMode redisMode = redisParserVO.getRedisMode();
                if (redisMode.equals((Object)RedisMode.SINGLE)) {
                    Config config = this.getSingleRedissonConfig(redisParserVO, redisParserVO.getChainDataBase());
                    this.chainClient = new RClient(Redisson.create((Config)config));
                    if (ObjectUtil.isNotNull((Object)redisParserVO.getScriptDataBase())) {
                        config = this.getSingleRedissonConfig(redisParserVO, redisParserVO.getScriptDataBase());
                        this.scriptClient = new RClient(Redisson.create((Config)config));
                    }
                } else if (redisMode.equals((Object)RedisMode.SENTINEL)) {
                    Config config = this.getSentinelRedissonConfig(redisParserVO, redisParserVO.getChainDataBase());
                    this.chainClient = new RClient(Redisson.create((Config)config));
                    if (ObjectUtil.isNotNull((Object)redisParserVO.getScriptDataBase())) {
                        config = this.getSentinelRedissonConfig(redisParserVO, redisParserVO.getScriptDataBase());
                        this.scriptClient = new RClient(Redisson.create((Config)config));
                    }
                }
            }
            if (ObjectUtil.isNull((Object)pollExecutor)) {
                NamedThreadFactory namedThreadFactory = new NamedThreadFactory("Redis-Polling-", false);
                pollExecutor = new ScheduledThreadPoolExecutor(2, (ThreadFactory)namedThreadFactory, new ThreadPoolExecutor.DiscardOldestPolicy());
            }
        }
        catch (Exception e) {
            throw new RedisException(e.getMessage());
        }
    }

    @Override
    public String getContent() {
        try {
            String chainKey = this.redisParserVO.getChainKey();
            Set<String> chainNameSet = this.chainClient.hkeys(chainKey);
            this.chainNum = chainNameSet.size();
            ArrayList<String> chainItemContentList = new ArrayList<String>();
            for (String chainName : chainNameSet) {
                String chainData = this.chainClient.hget(chainKey, chainName);
                RuleParsePluginUtil.ChainDto chainDto = RuleParsePluginUtil.parseChainKey((String)chainName);
                if (!StrUtil.isNotBlank((CharSequence)chainData)) continue;
                chainItemContentList.add(chainDto.toElXml(chainData));
                String chainSHA = DigestUtil.sha1Hex((String)chainData);
                this.chainSHAMap.put(chainName, chainSHA);
            }
            String chainAllContent = CollUtil.join(chainItemContentList, (CharSequence)"");
            String scriptAllContent = "";
            if (this.hasScript()) {
                String scriptKey = this.redisParserVO.getScriptKey();
                Set<String> scriptFieldSet = this.scriptClient.hkeys(scriptKey);
                this.scriptNum = scriptFieldSet.size();
                ArrayList<String> scriptItemContentList = new ArrayList<String>();
                for (String scriptFieldValue : scriptFieldSet) {
                    NodeConvertHelper.NodeSimpleVO nodeSimpleVO = NodeConvertHelper.convert((String)scriptFieldValue);
                    if (ObjectUtil.isNull((Object)nodeSimpleVO)) {
                        throw new RedisException(StrUtil.format((CharSequence)"The name of the redis field [{}] in scriptKey [{}] is invalid", (Object[])new Object[]{scriptFieldValue, scriptKey}));
                    }
                    String scriptData = this.scriptClient.hget(scriptKey, scriptFieldValue);
                    nodeSimpleVO.setScript(scriptData);
                    scriptItemContentList.add(RuleParsePluginUtil.toScriptXml((NodeConvertHelper.NodeSimpleVO)nodeSimpleVO));
                    String scriptSHA = DigestUtil.sha1Hex((String)scriptData);
                    this.scriptSHAMap.put(scriptFieldValue, scriptSHA);
                }
                scriptAllContent = StrUtil.format((CharSequence)"<nodes>{}</nodes>", (Object[])new Object[]{CollUtil.join(scriptItemContentList, (CharSequence)"")});
            }
            return StrUtil.format((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>", (Object[])new Object[]{scriptAllContent, chainAllContent});
        }
        catch (Exception e) {
            throw new RedisException(e.getMessage());
        }
    }

    public boolean hasScript() {
        if (ObjectUtil.isNull((Object)this.scriptClient) || ObjectUtil.isNull((Object)this.redisParserVO.getScriptDataBase())) {
            return false;
        }
        try {
            String scriptKey = this.redisParserVO.getScriptKey();
            if (StrUtil.isBlank((CharSequence)scriptKey)) {
                return false;
            }
            Set<String> scriptKeySet = this.scriptClient.hkeys(scriptKey);
            return !CollUtil.isEmpty(scriptKeySet);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void listenRedis() {
        String keyLuaOfChain = this.chainClient.scriptLoad("local keys = redis.call(\"hkeys\", KEYS[1]);\nreturn #keys;\n");
        String valueLuaOfChain = this.chainClient.scriptLoad("local key = KEYS[1];\nlocal field = KEYS[2];\nlocal value, err = redis.call(\"hget\", key, field);\nif value == false or value == nil then\n    return \"nil\";\nend\nlocal sha1 = redis.sha1hex(value);\nreturn sha1;");
        ChainPollingTask chainTask = new ChainPollingTask(this.redisParserVO, this.chainClient, this.chainNum, this.chainSHAMap, keyLuaOfChain, valueLuaOfChain);
        pollExecutor.scheduleAtFixedRate(chainTask, this.redisParserVO.getPollingStartTime().longValue(), this.redisParserVO.getPollingInterval().longValue(), TimeUnit.SECONDS);
        if (ObjectUtil.isNotNull((Object)this.scriptClient) && ObjectUtil.isNotNull((Object)this.redisParserVO.getScriptDataBase()) && StrUtil.isNotBlank((CharSequence)this.redisParserVO.getScriptKey())) {
            String keyLuaOfScript = this.scriptClient.scriptLoad("local keys = redis.call(\"hkeys\", KEYS[1]);\nreturn #keys;\n");
            String valueLuaOfScript = this.scriptClient.scriptLoad("local key = KEYS[1];\nlocal field = KEYS[2];\nlocal value, err = redis.call(\"hget\", key, field);\nif value == false or value == nil then\n    return \"nil\";\nend\nlocal sha1 = redis.sha1hex(value);\nreturn sha1;");
            ScriptPollingTask scriptTask = new ScriptPollingTask(this.redisParserVO, this.scriptClient, this.scriptNum, this.scriptSHAMap, keyLuaOfScript, valueLuaOfScript);
            pollExecutor.scheduleAtFixedRate(scriptTask, this.redisParserVO.getPollingStartTime().longValue(), this.redisParserVO.getPollingInterval().longValue(), TimeUnit.SECONDS);
        }
    }
}

