/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.redis.mode;

import cn.hutool.core.collection.CollectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.redisson.api.map.event.MapEntryListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;

public class RClient {
    private final RedissonClient redissonClient;
    private Map<String, String> map = new HashMap<String, String>();

    public RClient(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    public Map<String, String> getMap(String key) {
        RMapCache mapCache = this.redissonClient.getMapCache(key);
        Set mapFieldSet = mapCache.keySet();
        if (CollectionUtil.isEmpty((Collection)mapFieldSet)) {
            return this.map;
        }
        for (String field : mapFieldSet) {
            String value = (String)mapCache.get((Object)field);
            this.map.put(field, value);
        }
        return this.map;
    }

    public int addListener(String key, MapEntryListener listener) {
        RMapCache mapCache = this.redissonClient.getMapCache(key);
        return mapCache.addListener(listener);
    }

    public Set<String> hkeys(String key) {
        RMap map = this.redissonClient.getMap(key, (Codec)StringCodec.INSTANCE);
        return map.readAllKeySet();
    }

    public String hget(String key, String field) {
        RMap map = this.redissonClient.getMap(key, (Codec)StringCodec.INSTANCE);
        return (String)map.get((Object)field);
    }

    public String scriptLoad(String luaScript) {
        RScript script = this.redissonClient.getScript((Codec)StringCodec.INSTANCE);
        return script.scriptLoad(luaScript);
    }

    public String evalSha(String shaDigest, String ... args) {
        RScript script = this.redissonClient.getScript((Codec)StringCodec.INSTANCE);
        return script.evalSha(RScript.Mode.READ_ONLY, shaDigest, RScript.ReturnType.VALUE, Arrays.asList(args), new Object[0]).toString();
    }
}

