/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.redis.mode.polling;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestUtil;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.parser.helper.NodeConvertHelper;
import com.yomahub.liteflow.parser.redis.mode.RClient;
import com.yomahub.liteflow.parser.redis.mode.RedisParserHelper;
import com.yomahub.liteflow.parser.redis.vo.RedisParserVO;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class ScriptPollingTask
implements Runnable {
    private RedisParserVO redisParserVO;
    private RClient scriptClient;
    private Integer scriptNum;
    private Map<String, String> scriptSHAMap;
    private String keyLua;
    private String valueLua;
    LFLog LOG = LFLoggerManager.getLogger(ScriptPollingTask.class);

    public ScriptPollingTask(RedisParserVO redisParserVO, RClient scriptClient, Integer scriptNum, Map<String, String> scriptSHAMap, String keyLua, String valueLua) {
        this.redisParserVO = redisParserVO;
        this.scriptClient = scriptClient;
        this.scriptNum = scriptNum;
        this.scriptSHAMap = scriptSHAMap;
        this.keyLua = keyLua;
        this.valueLua = valueLua;
    }

    @Override
    public void run() {
        try {
            String scriptKey = this.redisParserVO.getScriptKey();
            String keyNum = this.scriptClient.evalSha(this.keyLua, scriptKey);
            this.scriptNum = Integer.parseInt(keyNum);
            ArrayList<String> needDelete = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.scriptSHAMap.entrySet()) {
                String scriptFieldValue = entry.getKey();
                String oldSHA = entry.getValue();
                String newSHA = this.scriptClient.evalSha(this.valueLua, scriptKey, scriptFieldValue);
                if (StrUtil.equals((CharSequence)newSHA, (CharSequence)"nil")) {
                    NodeConvertHelper.NodeSimpleVO nodeSimpleVO = NodeConvertHelper.convert((String)scriptFieldValue);
                    FlowBus.unloadScriptNode((String)nodeSimpleVO.getNodeId());
                    this.LOG.info("starting reload flow config... delete key={}", (Object)scriptFieldValue);
                    needDelete.add(scriptFieldValue);
                    continue;
                }
                if (StrUtil.equals((CharSequence)newSHA, (CharSequence)oldSHA)) continue;
                String scriptData = this.scriptClient.hget(scriptKey, scriptFieldValue);
                boolean changeSuccess = RedisParserHelper.changeScriptNode(scriptFieldValue, scriptData);
                if (BooleanUtil.isTrue((Boolean)changeSuccess)) {
                    this.scriptSHAMap.put(scriptFieldValue, newSHA);
                    continue;
                }
                needDelete.add(scriptFieldValue);
            }
            for (String scriptFieldValue : needDelete) {
                this.scriptSHAMap.remove(scriptFieldValue);
            }
            if (this.scriptNum > this.scriptSHAMap.size()) {
                Set<String> newScriptSet = this.scriptClient.hkeys(scriptKey);
                for (String scriptFieldValue : newScriptSet) {
                    if (this.scriptSHAMap.containsKey(scriptFieldValue)) continue;
                    String scriptData = this.scriptClient.hget(scriptKey, scriptFieldValue);
                    boolean isAddSuccess = RedisParserHelper.changeScriptNode(scriptFieldValue, scriptData);
                    if (BooleanUtil.isTrue((Boolean)isAddSuccess)) {
                        this.LOG.info("starting reload flow config... create key={} new value={},", (Object)scriptFieldValue, (Object)scriptData);
                        this.scriptSHAMap.put(scriptFieldValue, DigestUtil.sha1Hex((String)scriptData));
                        continue;
                    }
                    this.LOG.info("starting reload flow config... delete key={}", (Object)scriptFieldValue);
                    needDelete.add(scriptFieldValue);
                }
            }
        }
        catch (Exception e) {
            this.LOG.error("[Exception during script polling] " + e.getMessage(), (Throwable)e);
        }
    }
}

