/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.redis.mode.polling;

import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestUtil;
import com.yomahub.liteflow.builder.el.LiteFlowChainELBuilder;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.parser.redis.mode.RClient;
import com.yomahub.liteflow.parser.redis.vo.RedisParserVO;
import com.yomahub.liteflow.util.RuleParsePluginUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class ChainPollingTask
implements Runnable {
    private RedisParserVO redisParserVO;
    private RClient chainClient;
    private Integer chainNum;
    private Map<String, String> chainSHAMap;
    private String keyLua;
    private String valueLua;
    LFLog LOG = LFLoggerManager.getLogger(ChainPollingTask.class);

    public ChainPollingTask(RedisParserVO redisParserVO, RClient chainClient, Integer chainNum, Map<String, String> chainSHAMap, String keyLua, String valueLua) {
        this.redisParserVO = redisParserVO;
        this.chainClient = chainClient;
        this.chainNum = chainNum;
        this.chainSHAMap = chainSHAMap;
        this.keyLua = keyLua;
        this.valueLua = valueLua;
    }

    @Override
    public void run() {
        try {
            String chainKey = this.redisParserVO.getChainKey();
            String keyNum = this.chainClient.evalSha(this.keyLua, chainKey);
            this.chainNum = Integer.parseInt(keyNum);
            ArrayList<String> needDelete = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.chainSHAMap.entrySet()) {
                String chainId = entry.getKey();
                String oldSHA = entry.getValue();
                Pair pair = RuleParsePluginUtil.parseIdKey((String)chainId);
                if (((Boolean)pair.getKey()).booleanValue()) {
                    FlowBus.removeChain((String)((String)pair.getValue()));
                    needDelete.add(chainId);
                    continue;
                }
                String newSHA = this.chainClient.evalSha(this.valueLua, chainKey, chainId);
                if (StrUtil.equals((CharSequence)newSHA, (CharSequence)"nil")) {
                    FlowBus.removeChain((String)((String)pair.getValue()));
                    this.LOG.info("starting reload flow config... delete key={}", (Object)chainId);
                    needDelete.add(chainId);
                    continue;
                }
                if (StrUtil.equals((CharSequence)newSHA, (CharSequence)oldSHA)) continue;
                String chainData = this.chainClient.hget(chainKey, chainId);
                LiteFlowChainELBuilder.createChain().setChainId((String)pair.getValue()).setEL(chainData).build();
                this.LOG.info("starting reload flow config... update key={} new value={},", (Object)chainId, (Object)chainData);
                this.chainSHAMap.put(chainId, newSHA);
            }
            for (String chainId : needDelete) {
                this.chainSHAMap.remove(chainId);
            }
            if (this.chainNum > this.chainSHAMap.size()) {
                Set<String> newChainSet = this.chainClient.hkeys(chainKey);
                for (String chainId : newChainSet) {
                    Pair pair = RuleParsePluginUtil.parseIdKey((String)chainId);
                    if (this.chainSHAMap.containsKey(chainId)) continue;
                    String chainData = this.chainClient.hget(chainKey, chainId);
                    if (!((Boolean)pair.getKey()).booleanValue()) continue;
                    LiteFlowChainELBuilder.createChain().setChainId((String)pair.getValue()).setEL(chainData).build();
                    this.LOG.info("starting reload flow config... create key={} new value={},", (Object)chainId, (Object)chainData);
                    this.chainSHAMap.put(chainId, DigestUtil.sha1Hex((String)chainData));
                }
            }
        }
        catch (Exception e) {
            this.LOG.error("[Exception during chain polling] " + e.getMessage(), (Throwable)e);
        }
    }
}

