/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.redis.mode.subscribe;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.helper.NodeConvertHelper;
import com.yomahub.liteflow.parser.redis.exception.RedisException;
import com.yomahub.liteflow.parser.redis.mode.RClient;
import com.yomahub.liteflow.parser.redis.mode.RedisMode;
import com.yomahub.liteflow.parser.redis.mode.RedisParserHelper;
import com.yomahub.liteflow.parser.redis.vo.RedisParserVO;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import com.yomahub.liteflow.util.RuleParsePluginUtil;
import java.util.ArrayList;
import java.util.Map;
import org.redisson.Redisson;
import org.redisson.api.map.event.EntryCreatedListener;
import org.redisson.api.map.event.EntryRemovedListener;
import org.redisson.api.map.event.EntryUpdatedListener;
import org.redisson.api.map.event.MapEntryListener;
import org.redisson.config.Config;

public class RedisParserSubscribeMode
implements RedisParserHelper {
    private final RedisParserVO redisParserVO;
    private RClient chainClient;
    private RClient scriptClient;

    public RedisParserSubscribeMode(RedisParserVO redisParserVO) {
        this.redisParserVO = redisParserVO;
        try {
            try {
                this.chainClient = (RClient)ContextAwareHolder.loadContextAware().getBean("chainClient");
                this.scriptClient = (RClient)ContextAwareHolder.loadContextAware().getBean("scriptClient");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ObjectUtil.isNull((Object)this.chainClient)) {
                RedisMode redisMode = redisParserVO.getRedisMode();
                if (redisMode.equals((Object)RedisMode.SINGLE)) {
                    Config config = this.getSingleRedissonConfig(redisParserVO, redisParserVO.getChainDataBase());
                    this.chainClient = new RClient(Redisson.create((Config)config));
                    if (ObjectUtil.isNotNull((Object)redisParserVO.getScriptDataBase())) {
                        config = this.getSingleRedissonConfig(redisParserVO, redisParserVO.getScriptDataBase());
                        this.scriptClient = new RClient(Redisson.create((Config)config));
                    }
                } else if (redisMode.equals((Object)RedisMode.SENTINEL)) {
                    Config config = this.getSentinelRedissonConfig(redisParserVO, redisParserVO.getChainDataBase());
                    this.chainClient = new RClient(Redisson.create((Config)config));
                    if (ObjectUtil.isNotNull((Object)redisParserVO.getScriptDataBase())) {
                        config = this.getSentinelRedissonConfig(redisParserVO, redisParserVO.getScriptDataBase());
                        this.scriptClient = new RClient(Redisson.create((Config)config));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RedisException(e);
        }
    }

    @Override
    public String getContent() {
        try {
            Map<String, String> chainMap = this.chainClient.getMap(this.redisParserVO.getChainKey());
            ArrayList<String> chainItemContentList = new ArrayList<String>();
            for (Map.Entry<String, String> entry : chainMap.entrySet()) {
                String chainId = entry.getKey();
                String chainData = entry.getValue();
                RuleParsePluginUtil.ChainDto chainDto = RuleParsePluginUtil.parseChainKey((String)chainId);
                if (!StrUtil.isNotBlank((CharSequence)chainData)) continue;
                chainItemContentList.add(chainDto.toElXml(chainData));
            }
            String chainAllContent = CollUtil.join(chainItemContentList, (CharSequence)"");
            String scriptAllContent = "";
            if (this.hasScript()) {
                Map<String, String> scriptMap = this.scriptClient.getMap(this.redisParserVO.getScriptKey());
                ArrayList<String> scriptItemContentList = new ArrayList<String>();
                for (Map.Entry<String, String> entry : scriptMap.entrySet()) {
                    String scriptFieldValue = entry.getKey();
                    String scriptData = entry.getValue();
                    NodeConvertHelper.NodeSimpleVO nodeSimpleVO = NodeConvertHelper.convert((String)scriptFieldValue);
                    if (ObjectUtil.isNull((Object)nodeSimpleVO)) {
                        throw new RedisException(StrUtil.format((CharSequence)"The name of the redis field [{}] in scriptKey [{}] is invalid", (Object[])new Object[]{scriptFieldValue, this.redisParserVO.getScriptKey()}));
                    }
                    nodeSimpleVO.setScript(scriptData);
                    scriptItemContentList.add(RuleParsePluginUtil.toScriptXml((NodeConvertHelper.NodeSimpleVO)nodeSimpleVO));
                }
                scriptAllContent = StrUtil.format((CharSequence)"<nodes>{}</nodes>", (Object[])new Object[]{CollUtil.join(scriptItemContentList, (CharSequence)"")});
            }
            return StrUtil.format((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>", (Object[])new Object[]{scriptAllContent, chainAllContent});
        }
        catch (Exception e) {
            throw new RedisException(e);
        }
    }

    public boolean hasScript() {
        if (ObjectUtil.isNull((Object)this.scriptClient) || ObjectUtil.isNull((Object)this.redisParserVO.getScriptDataBase())) {
            return false;
        }
        try {
            Map<String, String> scriptMap = this.scriptClient.getMap(this.redisParserVO.getScriptKey());
            return !CollUtil.isEmpty(scriptMap);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void listenRedis() {
        String chainKey = this.redisParserVO.getChainKey();
        this.chainClient.addListener(chainKey, (MapEntryListener)((EntryCreatedListener)event -> {
            LOG.info("starting modify flow config... create key={} value={},", event.getKey(), event.getValue());
            String chainId = (String)event.getKey();
            String value = (String)event.getValue();
            RedisParserHelper.changeChain(chainId, value);
        }));
        this.chainClient.addListener(chainKey, (MapEntryListener)((EntryUpdatedListener)event -> {
            LOG.info("starting modify flow config... create key={} value={},", event.getKey(), event.getValue());
            String chainId = (String)event.getKey();
            String value = (String)event.getValue();
            RedisParserHelper.changeChain(chainId, value);
        }));
        this.chainClient.addListener(chainKey, (MapEntryListener)((EntryRemovedListener)event -> {
            LOG.info("starting reload flow config... delete key={}", event.getKey());
            Pair pair = RuleParsePluginUtil.parseIdKey((String)((String)event.getKey()));
            FlowBus.removeChain((String)((String)pair.getValue()));
        }));
        if (ObjectUtil.isNotNull((Object)this.scriptClient) && ObjectUtil.isNotNull((Object)this.redisParserVO.getScriptDataBase())) {
            String scriptKey = this.redisParserVO.getScriptKey();
            this.scriptClient.addListener(scriptKey, (MapEntryListener)((EntryCreatedListener)event -> {
                LOG.info("starting reload flow config... create key={} value={},", event.getKey(), event.getValue());
                RedisParserHelper.changeScriptNode((String)event.getKey(), (String)event.getValue());
            }));
            this.scriptClient.addListener(scriptKey, (MapEntryListener)((EntryUpdatedListener)event -> {
                LOG.info("starting reload flow config... update key={} new value={},", event.getKey(), event.getValue());
                RedisParserHelper.changeScriptNode((String)event.getKey(), (String)event.getValue());
            }));
            this.scriptClient.addListener(scriptKey, (MapEntryListener)((EntryRemovedListener)event -> {
                LOG.info("starting reload flow config... delete key={}", event.getKey());
                NodeConvertHelper.NodeSimpleVO nodeSimpleVO = NodeConvertHelper.convert((String)((String)event.getKey()));
                FlowBus.unloadScriptNode((String)nodeSimpleVO.getNodeId());
            }));
        }
    }
}

