/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.polling;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestUtil;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.polling.SqlReadPollTask;
import com.yomahub.liteflow.parser.sql.read.SqlRead;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSqlReadPollTask
implements SqlReadPollTask {
    private final Map<String, String> DATA_SHA_MAP = new HashMap<String, String>();
    private final SqlRead read;

    public AbstractSqlReadPollTask(SqlRead read) {
        this.read = read;
        if (!read.type().equals((Object)this.type())) {
            throw new ELSQLException("SqlReadPollTask type not match");
        }
    }

    @Override
    public void execute() {
        Map<String, String> newData = this.read.read();
        HashMap<String, String> saveElementMap = new HashMap<String, String>();
        List<String> deleteElementIds = new ArrayList();
        for (Map.Entry<String, String> entry : newData.entrySet()) {
            String id = entry.getKey();
            String element = entry.getValue();
            String newSHA = DigestUtil.sha1Hex((String)element);
            if (!this.DATA_SHA_MAP.containsKey(id)) {
                saveElementMap.put(id, element);
                this.DATA_SHA_MAP.put(id, newSHA);
                continue;
            }
            if (StrUtil.equals((CharSequence)newSHA, (CharSequence)this.DATA_SHA_MAP.get(id))) continue;
            saveElementMap.put(id, element);
            this.DATA_SHA_MAP.put(id, newSHA);
        }
        Set<String> oldIdList = this.DATA_SHA_MAP.keySet();
        Set<String> newIdList = newData.keySet();
        deleteElementIds = CollUtil.subtractToList(oldIdList, newIdList);
        for (String id : deleteElementIds) {
            this.DATA_SHA_MAP.remove(id);
        }
        if (CollUtil.isNotEmpty(saveElementMap)) {
            this.doSave(saveElementMap);
        }
        if (CollUtil.isNotEmpty(deleteElementIds)) {
            this.doDelete(deleteElementIds);
        }
    }

    @Override
    public void initData(Map<String, String> dataMap) {
        this.DATA_SHA_MAP.putAll(this.shaMapValue(dataMap));
    }

    public abstract void doSave(Map<String, String> var1);

    public abstract void doDelete(List<String> var1);

    private Map<String, String> shaMapValue(Map<String, String> dataMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        dataMap.forEach((k, v) -> result.put((String)k, DigestUtil.sha1Hex((String)v)));
        return result;
    }
}

