/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.read;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.parser.constant.SqlReadConstant;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.read.SqlRead;
import com.yomahub.liteflow.parser.sql.util.LiteFlowJdbcUtil;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSqlRead
implements SqlRead {
    public final SQLParserVO config;
    private static LFLog LOG = LFLoggerManager.getLogger(AbstractSqlRead.class);

    public AbstractSqlRead(SQLParserVO config) {
        this.config = config;
    }

    @Override
    public Map<String, String> read() {
        if (!this.needRead()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String sqlCmd = this.buildQuerySql();
        this.logSqlIfEnable(sqlCmd);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = LiteFlowJdbcUtil.getConn(this.config);
            stmt = conn.prepareStatement(sqlCmd, 1003, 1007);
            stmt.setFetchSize(SqlReadConstant.FETCH_SIZE_MAX);
            stmt.setString(1, this.config.getApplicationName());
            ParameterMetaData parameterMetaData = stmt.getParameterMetaData();
            if (parameterMetaData.getParameterCount() == 2) {
                stmt.setBoolean(2, true);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                String xml = this.buildXmlElement(rs);
                String uniqueKey = this.buildXmlElementUniqueKey(rs);
                result.put(uniqueKey, xml);
            }
        }
        catch (Exception e) {
            try {
                throw new ELSQLException(e.getMessage());
            }
            catch (Throwable throwable) {
                LiteFlowJdbcUtil.close(conn, stmt, rs);
                throw throwable;
            }
        }
        LiteFlowJdbcUtil.close(conn, stmt, rs);
        return result;
    }

    public abstract String buildQuerySql();

    public abstract String buildXmlElement(ResultSet var1) throws SQLException;

    public abstract String buildXmlElementUniqueKey(ResultSet var1) throws SQLException;

    public boolean needRead() {
        return true;
    }

    public String getStringFromRs(ResultSet rs, String field) throws SQLException {
        return rs.getString(field);
    }

    public String getStringFromRsWithCheck(ResultSet rs, String field) throws SQLException {
        String data = this.getStringFromRs(rs, field);
        if (StrUtil.isBlank((CharSequence)data)) {
            throw new ELSQLException(StrUtil.format((CharSequence)"field[{}] value is empty", (Object[])new Object[]{field}));
        }
        return data;
    }

    private void logSqlIfEnable(String sqlCmd) {
        if (!this.config.getSqlLogEnabled().booleanValue()) {
            return;
        }
        StringBuilder strBuilder = new StringBuilder("query sql: ");
        if (this.config.hasEnableField()) {
            String replaceAppName = StrUtil.replaceFirst((CharSequence)sqlCmd, (CharSequence)"?", (CharSequence)("'" + this.config.getApplicationName() + "'"));
            String executeSql = StrUtil.replaceFirst((CharSequence)replaceAppName, (CharSequence)"?", (CharSequence)Boolean.TRUE.toString());
            strBuilder.append(executeSql);
        } else {
            strBuilder.append(sqlCmd.replace("?", "'" + this.config.getApplicationName() + "'"));
        }
        LOG.info(strBuilder.toString());
    }
}

