/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.read.impl;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.parser.constant.ReadType;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.read.AbstractSqlRead;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ChainRead
extends AbstractSqlRead {
    public ChainRead(SQLParserVO config) {
        super(config);
    }

    @Override
    public String buildQuerySql() {
        String chainTableName = this.config.getChainTableName();
        String elDataField = this.config.getElDataField();
        String chainNameField = this.config.getChainNameField();
        String chainApplicationNameField = this.config.getChainApplicationNameField();
        String applicationName = this.config.getApplicationName();
        String chainEnableField = this.config.getChainEnableField();
        if (StrUtil.isBlank((CharSequence)chainTableName)) {
            throw new ELSQLException("You did not define the chainTableName property");
        }
        if (StrUtil.isBlank((CharSequence)applicationName) || StrUtil.isBlank((CharSequence)chainApplicationNameField)) {
            throw new ELSQLException("You did not define the applicationName or chainApplicationNameField property");
        }
        String sqlCmd = StrUtil.format((CharSequence)"SELECT {},{} FROM {} WHERE {}=?", (Object[])new Object[]{chainNameField, elDataField, chainTableName, chainApplicationNameField});
        if (StrUtil.isNotBlank((CharSequence)chainEnableField)) {
            sqlCmd = StrUtil.format((CharSequence)"{} {}", (Object[])new Object[]{sqlCmd, StrUtil.format((CharSequence)"AND {}=?", (Object[])new Object[]{chainEnableField})});
        }
        return sqlCmd;
    }

    @Override
    public String buildXmlElement(ResultSet rs) throws SQLException {
        String elDataField = this.config.getElDataField();
        return this.getStringFromRs(rs, elDataField);
    }

    @Override
    public String buildXmlElementUniqueKey(ResultSet rs) throws SQLException {
        String chainNameField = this.config.getChainNameField();
        return this.getStringFromRsWithCheck(rs, chainNameField);
    }

    @Override
    public ReadType type() {
        return ReadType.CHAIN;
    }
}

