/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.read.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.enums.ScriptTypeEnum;
import com.yomahub.liteflow.parser.constant.ReadType;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.read.AbstractSqlRead;
import com.yomahub.liteflow.parser.sql.util.LiteFlowJdbcUtil;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;

public class ScriptRead
extends AbstractSqlRead {
    public ScriptRead(SQLParserVO config) {
        super(config);
    }

    @Override
    public String buildQuerySql() {
        String scriptLanguageField = this.config.getScriptLanguageField();
        String scriptTableName = this.config.getScriptTableName();
        String scriptIdField = this.config.getScriptIdField();
        String scriptDataField = this.config.getScriptDataField();
        String scriptNameField = this.config.getScriptNameField();
        String scriptTypeField = this.config.getScriptTypeField();
        String scriptApplicationNameField = this.config.getScriptApplicationNameField();
        String applicationName = this.config.getApplicationName();
        String scriptEnableField = this.config.getScriptEnableField();
        if (StrUtil.isBlank((CharSequence)applicationName) || StrUtil.isBlank((CharSequence)scriptApplicationNameField)) {
            throw new ELSQLException("You did not define the applicationName or scriptApplicationNameField property");
        }
        String sqlCmd = null;
        sqlCmd = this.withLanguage() ? StrUtil.format((CharSequence)"SELECT {},{},{},{},{} FROM {} WHERE {}=?", (Object[])new Object[]{scriptIdField, scriptDataField, scriptNameField, scriptTypeField, scriptLanguageField, scriptTableName, scriptApplicationNameField}) : StrUtil.format((CharSequence)"SELECT {},{},{},{} FROM {} WHERE {}=?", (Object[])new Object[]{scriptIdField, scriptDataField, scriptNameField, scriptTypeField, scriptTableName, scriptApplicationNameField});
        if (StrUtil.isNotBlank((CharSequence)scriptEnableField)) {
            sqlCmd = StrUtil.format((CharSequence)"{} {}", (Object[])new Object[]{sqlCmd, StrUtil.format((CharSequence)"AND {}=?", (Object[])new Object[]{scriptEnableField})});
        }
        return sqlCmd;
    }

    @Override
    public String buildXmlElement(ResultSet rs) throws SQLException {
        String scriptDataField = this.config.getScriptDataField();
        return this.getStringFromRs(rs, scriptDataField);
    }

    @Override
    public String buildXmlElementUniqueKey(ResultSet rs) throws SQLException {
        String scriptIdField = this.config.getScriptIdField();
        String scriptNameField = this.config.getScriptNameField();
        String scriptTypeField = this.config.getScriptTypeField();
        String scriptLanguageField = this.config.getScriptLanguageField();
        String id = this.getStringFromRsWithCheck(rs, scriptIdField);
        String name = this.getStringFromRsWithCheck(rs, scriptNameField);
        String type = this.getStringFromRsWithCheck(rs, scriptTypeField);
        String language = this.withLanguage() ? this.getStringFromRs(rs, scriptLanguageField) : null;
        NodeTypeEnum nodeTypeEnum = NodeTypeEnum.getEnumByCode((String)type);
        if (Objects.isNull(nodeTypeEnum)) {
            throw new ELSQLException(StrUtil.format((CharSequence)"Invalid type value[{}]", (Object[])new Object[]{type}));
        }
        if (!nodeTypeEnum.isScript()) {
            throw new ELSQLException(StrUtil.format((CharSequence)"The type value[{}] is not a script type", (Object[])new Object[]{type}));
        }
        if (this.withLanguage() && !ScriptTypeEnum.checkScriptType((String)language)) {
            throw new ELSQLException(StrUtil.format((CharSequence)"The language value[{}] is invalid", (Object[])new Object[]{language}));
        }
        ArrayList keys = CollUtil.newArrayList((Object[])new String[]{id, type, name});
        if (StrUtil.isNotBlank((CharSequence)language)) {
            keys.add(language);
        }
        return StrUtil.join((CharSequence)":", (Iterable)keys);
    }

    @Override
    public boolean needRead() {
        if (StrUtil.isBlank((CharSequence)this.config.getScriptTableName())) {
            return false;
        }
        String sqlCmd = StrUtil.format((CharSequence)"SELECT 1 FROM {} ", (Object[])new Object[]{this.config.getScriptTableName()});
        Connection conn = LiteFlowJdbcUtil.getConn(this.config);
        return LiteFlowJdbcUtil.checkConnectionCanExecuteSql(conn, sqlCmd);
    }

    @Override
    public ReadType type() {
        return ReadType.SCRIPT;
    }

    private boolean withLanguage() {
        return StrUtil.isNotBlank((CharSequence)this.config.getScriptLanguageField());
    }
}

