/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.thread.NamedThreadFactory;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.XmlUtil;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.parser.constant.ReadType;
import com.yomahub.liteflow.parser.helper.NodeConvertHelper;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.read.SqlRead;
import com.yomahub.liteflow.parser.sql.read.SqlReadFactory;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class JDBCHelper {
    private SQLParserVO sqlParserVO;
    private static JDBCHelper INSTANCE;
    private static final int CORE_POOL_SIZE = 2;
    private static ScheduledThreadPoolExecutor pollExecutor;
    private static LFLog LOG;

    public static void init(SQLParserVO sqlParserVO) {
        try {
            INSTANCE = new JDBCHelper();
            if (StrUtil.isNotBlank((CharSequence)sqlParserVO.getDriverClassName())) {
                Class.forName(sqlParserVO.getDriverClassName());
            }
            INSTANCE.setSqlParserVO(sqlParserVO);
            if (sqlParserVO.getPollingEnabled().booleanValue() && ObjectUtil.isNull((Object)JDBCHelper.getPollExecutor())) {
                NamedThreadFactory namedThreadFactory = new NamedThreadFactory("SQL-Polling-", false);
                ScheduledThreadPoolExecutor threadPoolExecutor = new ScheduledThreadPoolExecutor(2, (ThreadFactory)namedThreadFactory, new ThreadPoolExecutor.DiscardOldestPolicy());
                JDBCHelper.setPollExecutor(threadPoolExecutor);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ELSQLException(e.getMessage());
        }
    }

    public static JDBCHelper getInstance() {
        return INSTANCE;
    }

    public String getContent() {
        SqlRead chainRead = SqlReadFactory.getSqlRead(ReadType.CHAIN);
        SqlRead scriptRead = SqlReadFactory.getSqlRead(ReadType.SCRIPT);
        Map<String, String> chainMap = chainRead.read();
        ArrayList chainList = new ArrayList();
        chainMap.entrySet().stream().filter(entry -> StrUtil.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).forEach(entry -> chainList.add(StrUtil.format((CharSequence)"<chain name=\"{}\"><![CDATA[{}]]></chain>", (Object[])new Object[]{XmlUtil.escape((String)((String)entry.getKey())), entry.getValue()})));
        String chainsContent = CollUtil.join(chainList, (CharSequence)"");
        Map<String, String> scriptMap = scriptRead.read();
        ArrayList scriptList = new ArrayList();
        scriptMap.forEach((scriptKey, elData) -> {
            NodeConvertHelper.NodeSimpleVO scriptVO = NodeConvertHelper.convert((String)scriptKey);
            String id = scriptVO.getNodeId();
            String name = scriptVO.getName();
            String type = scriptVO.getType();
            String language = scriptVO.getLanguage();
            if (StringUtils.isNotBlank((String)scriptVO.getLanguage())) {
                scriptList.add(StrUtil.format((CharSequence)"<node id=\"{}\" name=\"{}\" type=\"{}\" language=\"{}\"><![CDATA[{}]]></node>", (Object[])new Object[]{XmlUtil.escape((String)id), XmlUtil.escape((String)name), type, language, elData}));
            } else {
                scriptList.add(StrUtil.format((CharSequence)"<node id=\"{}\" name=\"{}\" type=\"{}\"><![CDATA[{}]]></node>", (Object[])new Object[]{XmlUtil.escape((String)id), XmlUtil.escape((String)name), type, elData}));
            }
        });
        String nodesContent = StrUtil.format((CharSequence)"<nodes>{}</nodes>", (Object[])new Object[]{CollUtil.join(scriptList, (CharSequence)"")});
        SqlReadFactory.getSqlReadPollTask(ReadType.CHAIN).initData(chainMap);
        SqlReadFactory.getSqlReadPollTask(ReadType.SCRIPT).initData(scriptMap);
        return StrUtil.format((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>", (Object[])new Object[]{nodesContent, chainsContent});
    }

    public void listenSQL() {
        pollExecutor.scheduleAtFixedRate(() -> {
            try {
                SqlReadFactory.getSqlReadPollTask(ReadType.CHAIN).execute();
            }
            catch (Exception ex) {
                LOG.error("poll chain fail", (Throwable)ex);
            }
        }, this.sqlParserVO.getPollingStartSeconds().longValue(), this.sqlParserVO.getPollingIntervalSeconds().longValue(), TimeUnit.SECONDS);
        pollExecutor.scheduleAtFixedRate(() -> {
            try {
                SqlReadFactory.getSqlReadPollTask(ReadType.SCRIPT).execute();
            }
            catch (Exception ex) {
                LOG.error("poll script fail", (Throwable)ex);
            }
        }, this.sqlParserVO.getPollingStartSeconds().longValue(), this.sqlParserVO.getPollingIntervalSeconds().longValue(), TimeUnit.SECONDS);
    }

    private void setSqlParserVO(SQLParserVO sqlParserVO) {
        this.sqlParserVO = sqlParserVO;
    }

    public static ScheduledThreadPoolExecutor getPollExecutor() {
        return pollExecutor;
    }

    public static void setPollExecutor(ScheduledThreadPoolExecutor pollExecutor) {
        JDBCHelper.pollExecutor = pollExecutor;
    }

    static {
        LOG = LFLoggerManager.getLogger(JDBCHelper.class);
    }
}

