/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.datasource.impl;

import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.yomahub.liteflow.exception.MissMavenDependencyException;
import com.yomahub.liteflow.parser.sql.datasource.LiteFlowDataSourceConnect;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import com.yomahub.liteflow.spi.ContextAware;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;

public class BaoMiDouDynamicDsConn
implements LiteFlowDataSourceConnect {
    @Override
    public boolean filter(SQLParserVO config) {
        if (StrUtil.isBlank((CharSequence)config.getBaomidouDataSource())) {
            return false;
        }
        boolean classLoadFlag = ClassLoaderUtil.isPresent((String)"com.baomidou.dynamic.datasource.DynamicRoutingDataSource");
        if (!classLoadFlag) {
            throw new MissMavenDependencyException("com.baomidou", "dynamic-datasource-spring-boot-starter");
        }
        return true;
    }

    @Override
    public Connection getConn(SQLParserVO config) throws Exception {
        String dataSourceName = config.getBaomidouDataSource();
        ContextAware contextAware = ContextAwareHolder.loadContextAware();
        DynamicRoutingDataSource dynamicRoutingDataSource = (DynamicRoutingDataSource)contextAware.getBean(DynamicRoutingDataSource.class);
        Map dataSources = dynamicRoutingDataSource.getDataSources();
        if (!dataSources.containsKey(dataSourceName)) {
            throw new ELSQLException(StrUtil.format((CharSequence)"can not found {} datasource", (Object[])new Object[]{dataSourceName}));
        }
        DataSource dataSource = dynamicRoutingDataSource.getDataSource(dataSourceName);
        return dataSource.getConnection();
    }

    public static class Constant {
        public static final String LOAD_CLASS_NAME = "com.baomidou.dynamic.datasource.DynamicRoutingDataSource";
        public static final String MAVEN_GROUP_ID = "com.baomidou";
        public static final String MAVEN_ARTIFACT_ID = "dynamic-datasource-spring-boot-starter";
    }
}

