/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.thread.NamedThreadFactory;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.XmlUtil;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.parser.constant.ReadType;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.polling.SqlReadPollTask;
import com.yomahub.liteflow.parser.sql.read.SqlRead;
import com.yomahub.liteflow.parser.sql.read.SqlReadFactory;
import com.yomahub.liteflow.parser.sql.read.vo.ChainVO;
import com.yomahub.liteflow.parser.sql.read.vo.ScriptVO;
import com.yomahub.liteflow.parser.sql.util.LiteFlowJdbcUtil;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCHelper {
    private static final Logger log = LoggerFactory.getLogger(JDBCHelper.class);
    private SQLParserVO sqlParserVO;
    private static JDBCHelper INSTANCE;
    private static final int CORE_POOL_SIZE = 2;
    private static ScheduledThreadPoolExecutor pollExecutor;
    private static LFLog LOG;

    public static void init(SQLParserVO sqlParserVO) {
        try {
            INSTANCE = new JDBCHelper();
            if (StrUtil.isNotBlank((CharSequence)sqlParserVO.getDriverClassName())) {
                Class.forName(sqlParserVO.getDriverClassName());
            }
            INSTANCE.setSqlParserVO(sqlParserVO);
            if (sqlParserVO.getPollingEnabled().booleanValue() && ObjectUtil.isNull((Object)JDBCHelper.getPollExecutor())) {
                NamedThreadFactory namedThreadFactory = new NamedThreadFactory("SQL-Polling-", false);
                ScheduledThreadPoolExecutor threadPoolExecutor = new ScheduledThreadPoolExecutor(2, (ThreadFactory)namedThreadFactory, new ThreadPoolExecutor.DiscardOldestPolicy());
                JDBCHelper.setPollExecutor(threadPoolExecutor);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ELSQLException(e);
        }
    }

    public static JDBCHelper getInstance() {
        return INSTANCE;
    }

    public String getContent() {
        SqlRead chainRead = SqlReadFactory.getSqlRead(ReadType.CHAIN);
        SqlRead scriptRead = SqlReadFactory.getSqlRead(ReadType.SCRIPT);
        List<ChainVO> chainVOList = chainRead.read();
        ArrayList chainList = new ArrayList();
        chainVOList.forEach(chainVO -> chainList.add(StrUtil.format((CharSequence)"<chain id=\"{}\" namespace=\"{}\"><route><![CDATA[{}]]></route><body><![CDATA[{}]]></body></chain>", (Object[])new Object[]{XmlUtil.escape((String)chainVO.getChainId()), StrUtil.emptyIfNull((CharSequence)chainVO.getNamespace()), StrUtil.emptyIfNull((CharSequence)chainVO.getRoute()), chainVO.getBody()})));
        String chainsContent = CollUtil.join(chainList, (CharSequence)"");
        List<ScriptVO> scriptVOList = scriptRead.read();
        ArrayList scriptList = new ArrayList();
        scriptVOList.forEach(scriptVO -> {
            String id = scriptVO.getNodeId();
            String name = scriptVO.getName();
            String type = scriptVO.getType();
            String language = scriptVO.getLanguage();
            String elData = scriptVO.getScript();
            if (StringUtils.isNotBlank((String)scriptVO.getLanguage())) {
                scriptList.add(StrUtil.format((CharSequence)"<node id=\"{}\" name=\"{}\" type=\"{}\" language=\"{}\"><![CDATA[{}]]></node>", (Object[])new Object[]{XmlUtil.escape((String)id), XmlUtil.escape((String)name), type, language, elData}));
            } else {
                scriptList.add(StrUtil.format((CharSequence)"<node id=\"{}\" name=\"{}\" type=\"{}\"><![CDATA[{}]]></node>", (Object[])new Object[]{XmlUtil.escape((String)id), XmlUtil.escape((String)name), type, elData}));
            }
        });
        String nodesContent = StrUtil.format((CharSequence)"<nodes>{}</nodes>", (Object[])new Object[]{CollUtil.join(scriptList, (CharSequence)"")});
        SqlReadPollTask<ChainVO> sqlReadPollTask4Chain = SqlReadFactory.getSqlReadPollTask(ReadType.CHAIN);
        sqlReadPollTask4Chain.initData(chainVOList);
        SqlReadPollTask<ScriptVO> sqlReadPollTask4Script = SqlReadFactory.getSqlReadPollTask(ReadType.SCRIPT);
        sqlReadPollTask4Script.initData(scriptVOList);
        return StrUtil.format((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>", (Object[])new Object[]{nodesContent, chainsContent});
    }

    public void listenSQL() {
        pollExecutor.scheduleAtFixedRate(() -> {
            try {
                SqlReadFactory.getSqlReadPollTask(ReadType.SCRIPT).execute();
                SqlReadFactory.getSqlReadPollTask(ReadType.CHAIN).execute();
            }
            catch (Exception ex) {
                LOG.error("poll chain fail", (Throwable)ex);
            }
        }, this.sqlParserVO.getPollingStartSeconds().longValue(), this.sqlParserVO.getPollingIntervalSeconds().longValue(), TimeUnit.SECONDS);
    }

    private void setSqlParserVO(SQLParserVO sqlParserVO) {
        this.sqlParserVO = sqlParserVO;
    }

    public SQLParserVO getSqlParserVO() {
        return this.sqlParserVO;
    }

    public static ScheduledThreadPoolExecutor getPollExecutor() {
        return pollExecutor;
    }

    public static void setPollExecutor(ScheduledThreadPoolExecutor pollExecutor) {
        JDBCHelper.pollExecutor = pollExecutor;
    }

    public void executeUpsert(String selectSql, String insertSql, String updateSql) throws ELSQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            conn = LiteFlowJdbcUtil.getConn(this.sqlParserVO);
            stmt = conn.prepareStatement(selectSql);
            resultSet = stmt.executeQuery();
            resultSet.next();
            String executeSql = resultSet.getInt(1) > 0 ? updateSql : insertSql;
            try (PreparedStatement insertStatement = conn.prepareStatement(executeSql);){
                insertStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new ELSQLException(e);
            }
        }
        catch (SQLException e) {
            try {
                throw new ELSQLException(e);
            }
            catch (Throwable throwable) {
                LiteFlowJdbcUtil.close(conn, stmt, resultSet);
                throw throwable;
            }
        }
        LiteFlowJdbcUtil.close(conn, stmt, resultSet);
    }

    public void createNodeInstanceIdTable() {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = LiteFlowJdbcUtil.getConn(this.sqlParserVO);
            stmt = conn.createStatement();
            stmt.executeUpdate("create table IF NOT EXISTS `node_instance_id_table`\n(\n    `application_name`     varchar(32)   NOT NULL,\n    `chain_id`           varchar(32)   NOT NULL,\n    `el_data_md5`          varchar(128)   NOT NULL,\n    `node_instance_id_map_json`     varchar(1024)   NOT NULL\n);");
        }
        catch (SQLException e) {
            try {
                throw new ELSQLException(e);
            }
            catch (Throwable throwable) {
                LiteFlowJdbcUtil.close(conn, stmt);
                throw throwable;
            }
        }
        LiteFlowJdbcUtil.close(conn, stmt);
    }

    static {
        LOG = LFLoggerManager.getLogger(JDBCHelper.class);
    }
}

