/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.zk.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.builder.LiteFlowNodeBuilder;
import com.yomahub.liteflow.builder.el.LiteFlowChainELBuilder;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.helper.NodeConvertHelper;
import com.yomahub.liteflow.parser.zk.exception.ZkException;
import com.yomahub.liteflow.parser.zk.vo.ZkParserVO;
import com.yomahub.liteflow.util.RuleParsePluginUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.retry.RetryNTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkParserHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ZkParserHelper.class);
    private final ZkParserVO zkParserVO;
    private final CuratorFramework client;
    private final String NODE_XML_PATTERN = "<nodes>{}</nodes>";
    private final String XML_PATTERN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>";

    public ZkParserHelper(ZkParserVO zkParserVO) {
        this.zkParserVO = zkParserVO;
        try {
            CuratorFramework client = CuratorFrameworkFactory.newClient((String)zkParserVO.getConnectStr(), (RetryPolicy)new RetryNTimes(10, 5000));
            client.start();
            this.client = client;
        }
        catch (Exception e) {
            throw new ZkException(e);
        }
    }

    public String getContent() {
        try {
            if (this.client.checkExists().forPath(this.zkParserVO.getChainPath()) == null) {
                throw new ZkException(StrUtil.format((CharSequence)"zk node[{}] is not exist", (Object[])new Object[]{this.zkParserVO.getChainPath()}));
            }
            List chainNameList = (List)this.client.getChildren().forPath(this.zkParserVO.getChainPath());
            ArrayList<String> chainItemContentList = new ArrayList<String>();
            for (String chainName : chainNameList) {
                RuleParsePluginUtil.ChainDto chainDto = RuleParsePluginUtil.parseChainKey((String)chainName);
                String chainData = new String((byte[])this.client.getData().forPath(StrUtil.format((CharSequence)"{}/{}", (Object[])new Object[]{this.zkParserVO.getChainPath(), chainName})));
                if (!StrUtil.isNotBlank((CharSequence)chainData)) continue;
                chainItemContentList.add(chainDto.toElXml(chainData));
            }
            String chainAllContent = CollUtil.join(chainItemContentList, (CharSequence)"");
            String scriptAllContent = "";
            if (this.hasScript()) {
                List scriptNodeValueList = (List)this.client.getChildren().forPath(this.zkParserVO.getScriptPath());
                ArrayList<String> scriptItemContentList = new ArrayList<String>();
                for (String scriptNodeValue : scriptNodeValueList) {
                    NodeConvertHelper.NodeSimpleVO nodeSimpleVO = NodeConvertHelper.convert((String)scriptNodeValue);
                    if (Objects.isNull(nodeSimpleVO)) {
                        throw new ZkException(StrUtil.format((CharSequence)"The name of the zk node is invalid:{}", (Object[])new Object[]{scriptNodeValue}));
                    }
                    String scriptData = new String((byte[])this.client.getData().forPath(StrUtil.format((CharSequence)"{}/{}", (Object[])new Object[]{this.zkParserVO.getScriptPath(), scriptNodeValue})));
                    nodeSimpleVO.setScript(scriptData);
                    scriptItemContentList.add(RuleParsePluginUtil.toScriptXml((NodeConvertHelper.NodeSimpleVO)nodeSimpleVO));
                }
                scriptAllContent = StrUtil.format((CharSequence)"<nodes>{}</nodes>", (Object[])new Object[]{CollUtil.join(scriptItemContentList, (CharSequence)"")});
            }
            return StrUtil.format((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>", (Object[])new Object[]{scriptAllContent, chainAllContent});
        }
        catch (Exception e) {
            throw new ZkException(e);
        }
    }

    public boolean hasScript() {
        if (StrUtil.isBlank((CharSequence)this.zkParserVO.getScriptPath())) {
            return false;
        }
        try {
            if (this.client.checkExists().forPath(this.zkParserVO.getScriptPath()) == null) {
                return false;
            }
            List chainNameList = (List)this.client.getChildren().forPath(this.zkParserVO.getScriptPath());
            return !CollUtil.isEmpty((Collection)chainNameList);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void listenZkNode() {
        CuratorCache cache1 = CuratorCache.build((CuratorFramework)this.client, (String)this.zkParserVO.getChainPath(), (CuratorCache.Options[])new CuratorCache.Options[0]);
        cache1.start();
        cache1.listenable().addListener((type, oldData, data) -> {
            ChildData currChildData = data == null ? oldData : data;
            String path = currChildData.getPath();
            String value = new String(currChildData.getData());
            if (StrUtil.isBlank((CharSequence)value)) {
                return;
            }
            if (ListUtil.toList((Object[])new CuratorCacheListener.Type[]{CuratorCacheListener.Type.NODE_CREATED, CuratorCacheListener.Type.NODE_CHANGED}).contains(type)) {
                LOG.info("starting reload flow config... {} path={} value={},", new Object[]{type.name(), path, value});
                String chainName = FileNameUtil.getName((String)path);
                Pair pair = RuleParsePluginUtil.parseIdKey((String)chainName);
                String id = (String)pair.getValue();
                if (((Boolean)pair.getKey()).booleanValue()) {
                    LiteFlowChainELBuilder.createChain().setChainId(id).setEL(value).build();
                } else {
                    FlowBus.removeChain((String)id);
                }
            } else if (CuratorCacheListener.Type.NODE_DELETED.equals((Object)type)) {
                LOG.info("starting reload flow config... delete path={}", (Object)path);
                String chainName = FileNameUtil.getName((String)path);
                Pair pair = RuleParsePluginUtil.parseIdKey((String)chainName);
                FlowBus.removeChain((String)((String)pair.getValue()));
            }
        });
        if (StrUtil.isNotBlank((CharSequence)this.zkParserVO.getScriptPath())) {
            CuratorCache cache2 = CuratorCache.build((CuratorFramework)this.client, (String)this.zkParserVO.getScriptPath(), (CuratorCache.Options[])new CuratorCache.Options[0]);
            cache2.start();
            cache2.listenable().addListener((type, oldData, data) -> {
                ChildData currChildData = data == null ? oldData : data;
                String path = currChildData.getPath();
                String value = new String(currChildData.getData());
                if (StrUtil.isBlank((CharSequence)value)) {
                    return;
                }
                if (ListUtil.toList((Object[])new CuratorCacheListener.Type[]{CuratorCacheListener.Type.NODE_CREATED, CuratorCacheListener.Type.NODE_CHANGED}).contains(type)) {
                    LOG.info("starting reload flow config... {} path={} value={},", new Object[]{type.name(), path, value});
                    String scriptNodeValue = FileNameUtil.getName((String)path);
                    NodeConvertHelper.NodeSimpleVO nodeSimpleVO = NodeConvertHelper.convert((String)scriptNodeValue);
                    if (nodeSimpleVO.getEnable().booleanValue()) {
                        LiteFlowNodeBuilder.createScriptNode().setId(nodeSimpleVO.getNodeId()).setType(NodeTypeEnum.getEnumByCode((String)nodeSimpleVO.getType())).setName(nodeSimpleVO.getName()).setScript(value).setLanguage(nodeSimpleVO.getLanguage()).build();
                    } else {
                        FlowBus.unloadScriptNode((String)nodeSimpleVO.getNodeId());
                    }
                } else if (CuratorCacheListener.Type.NODE_DELETED.equals((Object)type)) {
                    LOG.info("starting reload flow config... delete path={}", (Object)path);
                    String scriptNodeValue = FileNameUtil.getName((String)path);
                    NodeConvertHelper.NodeSimpleVO nodeSimpleVO = NodeConvertHelper.convert((String)scriptNodeValue);
                    FlowBus.unloadScriptNode((String)nodeSimpleVO.getNodeId());
                }
            });
        }
    }
}

