/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.script.graaljs;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ScriptTypeEnum;
import com.yomahub.liteflow.script.ScriptExecuteWrap;
import com.yomahub.liteflow.script.ScriptExecutor;
import com.yomahub.liteflow.script.exception.ScriptLoadException;
import com.yomahub.liteflow.util.CopyOnWriteHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class GraalJavaScriptExecutor
extends ScriptExecutor {
    private final Map<String, Source> scriptMap = new CopyOnWriteHashMap();
    private Engine engine;

    public ScriptExecutor init() {
        this.engine = Engine.create();
        return this;
    }

    public void load(String nodeId, String script) {
        try {
            this.scriptMap.put(nodeId, Source.create((String)"js", (CharSequence)((CharSequence)this.compile(script))));
        }
        catch (Exception e) {
            String errorMsg = StrUtil.format((CharSequence)"script loading error for node[{}], error msg:{}", (Object[])new Object[]{nodeId, e.getMessage()});
            throw new ScriptLoadException(errorMsg);
        }
    }

    public void unLoad(String nodeId) {
        this.scriptMap.remove(nodeId);
    }

    public List<String> getNodeIds() {
        return new ArrayList<String>(this.scriptMap.keySet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeScript(ScriptExecuteWrap wrap) {
        if (!this.scriptMap.containsKey(wrap.getNodeId())) {
            String errorMsg = StrUtil.format((CharSequence)"script for node[{}] is not loaded", (Object[])new Object[]{wrap.getNodeId()});
            throw new ScriptLoadException(errorMsg);
        }
        try (Context context = Context.newBuilder((String[])new String[0]).allowAllAccess(true).engine(this.engine).build();){
            Value bindings = context.getBindings("js");
            this.bindParam(wrap, (arg_0, arg_1) -> ((Value)bindings).putMember(arg_0, arg_1), (s, o) -> {
                if (!bindings.hasMember(s)) {
                    bindings.putMember(s, o);
                }
            });
            Value value = context.eval(this.scriptMap.get(wrap.getNodeId()));
            if (value.isBoolean()) {
                Boolean bl = value.asBoolean();
                return bl;
            }
            if (value.isNumber()) {
                Integer n = value.asInt();
                return n;
            }
            if (value.isString()) {
                String string = value.asString();
                return string;
            }
            Value value2 = value;
            return value2;
        }
    }

    public void cleanCache() {
        this.scriptMap.clear();
    }

    public ScriptTypeEnum scriptType() {
        return ScriptTypeEnum.JS;
    }

    public Object compile(String script) throws Exception {
        String wrapScript = StrUtil.format((CharSequence)"function process(){{}} process();", (Object[])new Object[]{script});
        Context context = Context.newBuilder((String[])new String[0]).allowAllAccess(true).engine(this.engine).build();
        context.parse(Source.create((String)"js", (CharSequence)wrapScript));
        return wrapScript;
    }
}

