/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.script.javax;

import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ScriptTypeEnum;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.script.ScriptExecuteWrap;
import com.yomahub.liteflow.script.ScriptExecutor;
import com.yomahub.liteflow.script.exception.ScriptLoadException;
import com.yomahub.liteflow.util.CopyOnWriteHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.noear.liquor.eval.CodeSpec;
import org.noear.liquor.eval.Execable;
import org.noear.liquor.eval.ParamSpec;
import org.noear.liquor.eval.Scripts;

public class JavaxExecutor
extends ScriptExecutor {
    private final Map<String, Execable> compiledScriptMap = new CopyOnWriteHashMap();
    private boolean isCache;

    public ScriptExecutor init() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        String isCacheValue = (String)liteflowConfig.getScriptSetting().get("javax-is-cache");
        this.isCache = Boolean.parseBoolean(isCacheValue);
        super.lifeCycle(null);
        return this;
    }

    public void load(String nodeId, String script) {
        try {
            this.compiledScriptMap.put(nodeId, (Execable)this.compile(script));
        }
        catch (Exception e) {
            String errorMsg = StrUtil.format((CharSequence)"script loading error for node[{}],error msg:{}", (Object[])new Object[]{nodeId, e.getMessage()});
            throw new ScriptLoadException(errorMsg);
        }
    }

    public void unLoad(String nodeId) {
        this.compiledScriptMap.remove(nodeId);
    }

    public List<String> getNodeIds() {
        return new ArrayList<String>(this.compiledScriptMap.keySet());
    }

    public Object executeScript(ScriptExecuteWrap wrap) throws Exception {
        if (!this.compiledScriptMap.containsKey(wrap.getNodeId())) {
            String errorMsg = StrUtil.format((CharSequence)"script for node[{}] is not loaded", (Object[])new Object[]{wrap.getNodeId()});
            throw new ScriptLoadException(errorMsg);
        }
        Execable execable = this.compiledScriptMap.get(wrap.getNodeId());
        return execable.exec(new Object[]{wrap});
    }

    public void cleanCache() {
        this.compiledScriptMap.clear();
    }

    public ScriptTypeEnum scriptType() {
        return ScriptTypeEnum.JAVA;
    }

    public Object compile(String script) throws Exception {
        CodeSpec codeSpec = new CodeSpec(this.convertScript(script)).returnType(Object.class).parameters(new Map.Entry[]{new ParamSpec("_meta", ScriptExecuteWrap.class)}).cached(this.isCache);
        return Scripts.compile((CodeSpec)codeSpec);
    }

    private String convertScript(String script) {
        String script1 = script.replaceAll("public class", "class").replaceAll("private class", "class").replaceAll("protected class", "class");
        String className = ReUtil.getGroup1((String)"class\\s+(\\w+)\\s+implements", (CharSequence)script1);
        if (StrUtil.isBlank((CharSequence)className)) {
            throw new RuntimeException("cannot find class defined");
        }
        return "import com.yomahub.liteflow.script.body.CommonScriptBody;\n" + script1 + "\n" + StrUtil.format((CharSequence)"{} item = new {}();\n", (Object[])new Object[]{className, className}) + "if (CommonScriptBody.class.isInstance(item)){item.body(_meta);return null;}else{return item.body(_meta);}";
    }
}

