/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.script.python;

import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ScriptTypeEnum;
import com.yomahub.liteflow.script.ScriptExecuteWrap;
import com.yomahub.liteflow.script.ScriptExecutor;
import com.yomahub.liteflow.script.exception.ScriptLoadException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.python.core.PyCode;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class PythonScriptExecutor
extends ScriptExecutor {
    private PythonInterpreter pythonInterpreter;
    private final String RESULT_KEY = "result";
    private final Map<String, PyCode> compiledScriptMap = new HashMap<String, PyCode>();

    public ScriptExecutor init() {
        PySystemState systemState = new PySystemState();
        systemState.setdefaultencoding("UTF-8");
        this.pythonInterpreter = new PythonInterpreter(null, systemState);
        return this;
    }

    public void load(String nodeId, String script) {
        try {
            PyCode pyCode = (PyCode)this.compile(script);
            this.compiledScriptMap.put(nodeId, pyCode);
        }
        catch (Exception e) {
            String errorMsg = StrUtil.format((CharSequence)"script loading error for node[{}],error msg:{}", (Object[])new Object[]{nodeId, e.getMessage()});
            throw new ScriptLoadException(errorMsg);
        }
    }

    public void unLoad(String nodeId) {
        this.compiledScriptMap.remove(nodeId);
    }

    public List<String> getNodeIds() {
        return new ArrayList<String>(this.compiledScriptMap.keySet());
    }

    public Object executeScript(ScriptExecuteWrap wrap) throws Exception {
        if (!this.compiledScriptMap.containsKey(wrap.getNodeId())) {
            String errorMsg = StrUtil.format((CharSequence)"script for node[{}] is not loaded", (Object[])new Object[]{wrap.getNodeId()});
            throw new ScriptLoadException(errorMsg);
        }
        PyCode compiledScript = this.compiledScriptMap.get(wrap.getNodeId());
        this.bindParam(wrap, (arg_0, arg_1) -> ((PythonInterpreter)this.pythonInterpreter).set(arg_0, arg_1), (arg_0, arg_1) -> ((PythonInterpreter)this.pythonInterpreter).set(arg_0, arg_1));
        this.pythonInterpreter.exec((PyObject)compiledScript);
        PyObject result = this.pythonInterpreter.get("result");
        if (result == null) {
            return null;
        }
        this.pythonInterpreter.cleanup();
        switch (wrap.getCmp().getType()) {
            case BOOLEAN_SCRIPT: {
                return result.__tojava__(Boolean.class);
            }
            case FOR_SCRIPT: {
                return result.__tojava__(Integer.class);
            }
        }
        return result.__tojava__(Object.class);
    }

    public void cleanCache() {
        this.compiledScriptMap.clear();
    }

    public ScriptTypeEnum scriptType() {
        return ScriptTypeEnum.PYTHON;
    }

    public Object compile(String script) throws Exception {
        return this.pythonInterpreter.compile(this.convertScript(script));
    }

    private String convertScript(String script) {
        String[] lineArray = script.split("\\n");
        List<String> noBlankLineList = Arrays.stream(lineArray).filter(s -> !StrUtil.isBlank((CharSequence)s)).collect(Collectors.toList());
        String blankStr = ReUtil.getGroup0((String)"^[ ]*", (CharSequence)((CharSequence)noBlankLineList.get(0)));
        StringBuilder scriptSB = new StringBuilder();
        noBlankLineList.forEach(s -> scriptSB.append(StrUtil.format((CharSequence)"{}\n", (Object[])new Object[]{s.replaceFirst(blankStr, "")})));
        return scriptSB.toString().replace("return", "result=");
    }
}

